<link rel="stylesheet" type="text/css" href="./assets/DataTables/datatables.min.css"/>
<script type="text/javascript" src="./assets/DataTables/datatables.min.js"></script>
<style media="screen">
div.dataTables_wrapper div.dataTables_filter input {
    width: 100%;
}
div.dataTables_wrapper div.dataTables_filter input{
  margin-left:0;
}
.panel-actions a, .panel-actions .panel-action{
	font-size: 21px;
}
.formholder h5 {
    font-size: 15px;
    font-weight: 600;
}
.for-input {
  padding: 8px;
  height: 40px;
  font-size: 14px;
  border: none;
  outline: none;
	margin-top: 2px;
}

.panelControl {
    float: right;
}
.table-holder {
  position: relative;
  top: 159px;
  background: white;
  width: 88%;
  margin: 0 auto;
  margin-left: 121px;
}
.title-model {
  padding-top: 4px;
  float: left;
  margin-left: 26px;
}
.close-btn-holder {
  right: 0;
  top: -41px;
  position: absolute;
  background: white;
  padding: 10px;
}
.table-responsive {
  min-height: 223px;
}
.center-panel {
  width: 68%;
  margin: 0 auto;
}
.panel-title{
  font-size:17px;
}
.td_double_border {
    border-bottom: 2px solid;
    width: 100%;
    display: block;
    text-align: center;
}
.td_double_border:before{
  content:'';
  display:block;
  border-bottom: 1px solid;
}
</style>
<header class="page-header">
	<h2>Ledger Account - Report</h2>
</header>

<div class="center-panel">
	<section class="panel">
		<header class="panel-heading">
			<div class="panelControl">
        <span><?="<strong>".$fromdate."</strong> To <strong>".$todate."</strong>"?></span>
				<a class="btn" href="?module=reports&action=leader_account" title="Home"> <i class="fa fa-list"></i> Client ledger</a>
				<a class="btn" href="?module=home&action=index" title="Home"> <i class="fa fa-home"></i> Home</a>
			</div>
			<h2 class="panel-title" style="text-transform:capitalize"><?=$client['name']?></h2>
			<h2 class="panel-title">Ledger Account In: <?=$current_name?></h2>
      <span>Balance sheet</span>
		</header>
		<div class="panel-body">
			<div class="table-responsive">
				<table class="table mb-none" style="font-size:13px;" id="printing_area">
					<thead>
            <tr>
              <th>SN.</th>
              <th>DATE</th>
              <th>VOUCHER TYPE</th>
              <th>VOUCHER NUMBER</th>
              <th>DEBIT</th>
              <th>CREDIT</th>
            </tr>
					</thead>
					<tbody>
            <?$count=1?>
            <?php foreach ($ledger_list as $index => $leader){?>
              <tr>
                <td><?=$count++?></td>
                <td><?=$leader['date']?></td>
                <td style="text-transform:capitalize;"><?=$leader['type']?> <?if ($leader['paymentType']=="credit") {
                  echo "(Credit)";
                }?></td>
                <td style="font-weight:400;text-align:center;font-size:15px;"><?=$leader['number']?></td>
                <td><?if($leader['type'] == 'invoice') echo formatN($leader['amount'],2);?></td>
                <td><?if($leader['type'] == 'receipt') echo formatN($leader['amount'],2);?></td>
              </tr>
            <?php }; ?>

            <?php if ($ledger_total){?>
              <tr class="tr_balance bg-dark">
                <td colspan="4" style="text-align:right"><strong>Clossing Balance: <?=$current_name?></strong> </td>
                <td style="display: none;"></td>
                <td style="display: none;"></td>
                <td style="display: none;"></td>
                <td><strong><span class="td_double_border"><?=formatN($ledger_total['invoice_grand'],2)?></span></strong> </td>
                <td><strong><span class="td_double_border"><?=formatN($ledger_total['receipt_grand'],2)?></span></strong> </td>
              </tr>
            <?php }; ?>
					</tbody>
				</table>
			</div>
		</div>
	</section>
</div>


