<link href="https://fonts.googleapis.com/css?family=Roboto:300,400,700" rel="stylesheet">
<style>
body {
  target-new:tab;
  -webkit-print-color-adjust: exact !important;
  margin:0;
  font-family: 'Roboto', sans-serif;
}
@page {
  size: auto;
  margin: 0mm;
}
.company-holder {
    width: 93%;
    margin: 0 auto;
}
.company-holder .company-details {
    width: 80%;
    float: left;
    text-align: right;
}
.company-info ul li{
  display: inline-block;
  margin-left: 21px;
}
.company-holder .company-details ul {
	list-style: none;
}
.company-holder .logo-bar {
    width: 20%;
    float: left;
}
.company-holder .logo-bar .logo {
    margin-top: 19px;
}
.company-holder .logo-bar .logo img {
    display: block;
    width: 100%;
    height: auto;
}
.header {
    width: 100%;
    text-align: center;
}
.header h2 {
    float: left;
    width: 100%;
	font-weight:300;
    background: black;
    color: white;
}
.GRN-header {
    margin: 0 auto;
    width: 93%;
}

.GRN-details {
    width: 80%;
    margin: 0 auto;
}
.GRN-header .supplier-details {
    width: 50%;
    float: left;
	/* height: 190px; */
}
.GRN-header .supplier-details ul{
	list-style: none;
	padding: 0;
}
.GRN-header .supplier-details ul li {
    border-bottom: 1px solid #dee2e6;
    padding: 5px;
}
.GRN-details table {
    width: 100%;
	border-collapse: collapse;
}
.GRN-details  table thead th {
    vertical-align: middle;
	border-top: 2px solid black;
    border-bottom: 2px solid black;
}
.GRN-details table tr{
	height: 32px;
	border-top:1px solid #dee2e6;
	border-bottom:1px solid #dee2e6;
}
.GRN-details table th {
   text-align: left
}
.GRN-details .totalAmount {
    width: 43%;
    float: right;
}
.GRN-details .remarkArea{
	width: 40%;
	margin-top: 10%;
}
</style>
<div class="row">
	<div class="col-md-8">
		<div class="company-holder col-md-12">
			<div class="logo-bar"><div class="logo"><img src="assets/<?=$company['logo']?>" alt="logo"/></div></div>
			<div class="company-details">
				<h3><?=$company['name']?></h3>
				<div class="company-info">
					<ul>
						<li>TIN: <?=$company['tin']?></li>
						<li><?=$company['address']?></li>
						<li><?=$company['mobile']?> | <?=$company['tel']?></li>
						<li><?=$company['email']?></li>
					</ul>
				</div>
			</div>
		</div>
		<div class="header col-md-12"><h2>Local Purchased Order (LPO)</h2></div>
		<div class="GRN-header col-md-12">
			<div class="supplier-details col-md-6">
				<ul style="text-align: left">
					<li>Supplier Name: <span style="text-transform: uppercase;"><?=$lpo[0]['suppliername']?></span> </li>
					<li>Supplier Invoice No.: -</li>
					<li>Payment: CREDIT DAYS: 0</li>
					<!--<li>LPO. No.: -</li>-->
				</ul>
			</div>
			<div class="supplier-details col-md-6">
				<ul style="text-align: right">
					<li>Date: <?=fDate($lpo[0]['issuedate'])?></li>
					<li>LPO. No. : <strong><?=$lpo[0]['lponumber']?></strong> </li>
					<!-- <li>Location: Stores</li> -->
					<li>Currency: (<strong><?=$lpo[0]['currency_name']?></strong>) <span style="text-transform:capitalize"><?=$lpo[0]['currency_description']?></span> </li>
				</ul>
			</div>
		</div>
		<div class="GRN-details col-md-12">
			<table>
				<thead>
					<tr>
						<th>SN</th>
						<th>Product Name</th>
            <th style="text-align: center;">Quantity</th>
            <th style="text-align: center;">Rate (<?=$lpo[0]['currency_name']?>)</th>
						<th style="text-align: right;">Purchased Cost (<?=$lpo[0]['currency_name']?>)</th>
					</tr>
				</thead>

				<? $count=1;
					foreach($lpo as $index =>$g ){?>

						<tr id="grn<?=$count?>">
							<td><?=$count?></td>
							<td><?=$g['productname']?></td>
							<td style="text-align: center;"><?=$g['qty']?></td>
							<td style="text-align: center;"><?=formatN($g['rate'])?></td>
							<td style="text-align: right;"><?=formatN($g['prod_cost'])?></td>
						</tr>

				<?$count++;}?>

			</table>
			<div class="totalAmount">
				<table>
					<tr>
						<td>Exclusive Amount</td>
						<td style="text-align: right;"><strong><?=formatN($lpo[0]['total_amount'])?></strong></td>
					</tr>
					<tr>
						<td>VAT Amount</td>
						<td style="text-align: right;"><strong><?=formatN($lpo[0]['grand_vatamount'])?></strong></td>
					</tr>
          <tr>
						<td>Inclusive Amount</td>
						<td style="text-align: right;"><strong><?=formatN($lpo[0]['full_amount'])?></strong></td>
					</tr>
				</table>
			</div>
			<div class="remarkArea">
				<table>
					<tr>
						<td><strong>Created By</strong> :</td>
						<td style="text-align: right;"><?=$lpo[0]['issuedby']?></td>
					</tr>
					<tr>
						<td><strong>Received By</strong> :</td>
						<td style="text-align: right;"></td>
					</tr>
					<tr>
						<td><strong>Signature</strong> :</td>
						<td style="text-align: right;"></td>
					</tr>
				</table>
			</div>
		</div>
	</div>
</div>
<script>
	window.print();
</script>
