<style media="screen">
.input-group-rounded input.form-control:first-child, .input-group-rounded input.form-control:last-child, .input-search input.form-control:first-child, .input-search input.form-control:last-child {
		border-radius: 0;
		height: 44px;
		font-size: 15px;
}
.table {
		width: 100%;
		font-size: 15px;
}
.table .actions a:hover, .table .actions-hover a {
		color: #ffffff;
}
.table .actions a:hover, .table .actions-hover a:hover {
		color: #ffffff;
}
.dropleft .dropdown-menu {
    top: 0;
    right: 100%;
    left: auto;
    margin-top: 0;
    margin-right: .125rem;
}
a.dropdown-item{
	text-decoration:none;
}
.dropdown-item {
    display: block;
    width: 100%;
    padding: .25rem 1.5rem;
    clear: both;
    font-weight: 400;
    color: #212529;
    text-align: inherit;
    white-space: nowrap;
    background-color: transparent;
    border: 0;
}
.center-panel{
	margin:0 auto;
	width:83%;
}
.productpricelist {
  position: fixed;
  z-index: 99;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background: rgba(0, 0, 0, 0.5803921568627451);
  display: none;
	overflow:hidden;
	overflow-y:scroll;
}
.productpricelist .table-holder {
  position: relative;
  top: 129px;
  background: #ffffff;
  width: 50%;
  margin: 0 auto;
  PADDING: 20PX;
  /* margin-left: 121px; */
}
.productpricelist .title-model {
    padding-top: 4px;
    float: left;
    margin-left: 26px;
}
.productpricelist .close-btn-holder {
    padding-top: 4px;
    width: 73px;
    float: right;
}
.product_details {
    width: 100%;
    float: left;
}
.pro-details,.pro-barcode{
	float:left;
}
.pro-details{
	width:70%;
}
.pro-barcode{
	width:30%;
}
.pro-container .pro-name,.pro-value{
	padding: 5px;
}
.pro-container .pro-name {
    font-size: 16px;
    float: left;
    width: 40%;
    font-weight: 600;
}
.pro-container .pro-value {
    float: left;
    width: 60%;
}
.canvas-holder{
	width:50%;
	float:left;
}
.canvas-holder .barcode-name{
	display:block;
}
.category_header {
  font-size: 15px;
  font-weight: 600;
  text-transform: capitalize;
  margin-left: 5px;
}
.category_header:before{
	content: '';
  width: 77%;
  display: inline-block;
  border: 1px solid #ecedf0;
  position: absolute;
  right: 0;
  margin-top: 12px;
}
.button_tbl {
    width: 51%;
		height:43px;
    margin: auto;
}
.stock_details_holder{
	display:none;
}
.button_tbl .btn-primary{
	background: transparent;
  color: #0088cc;
  text-shadow: none;
}
.client_details_holder{
	display:none;
}
.product-descption {
  width: 100%;
  padding: 10px;
  float: left;
}
</style>
<header class="page-header">
	<h2>Products</h2>
</header>

<!-- product screen -->
<div class="productpricelist">
	<div class="table-holder">
		<div class="title-model">
			<h4><i class="fa fa-file"></i> Product screen</h4>
		</div>
		<div class="title-model">
			<a class="btn btn-danger" onclick="closeProductScreen()" type="button" name="button">CLOSE</a>
		</div>
		<div class="product_details_holder">
			<div class="product_details">
				<p class="category_header">Product Details</p>
				<div class="pro-details">
					<div class="pro-container">
						<div class="pro-name">Name</div>
						<div class="pro-value pname">0</div>
					</div>
					<div class="pro-container">
						<div class="pro-name">Department</div>
						<div class="pro-value pdepart">0</div>
					</div>
					<div class="pro-container">
						<div class="pro-name">Category</div>
						<div class="pro-value pcategory">0</div>
					</div>
					<div class="pro-container">
						<div class="pro-name">Brand</div>
						<div class="pro-value pbrand">0</div>
					</div>
					<div class="pro-container">
						<div class="pro-name">VAT</div>
						<div class="pro-value pvat">0</div>
					</div>
					<div class="pro-container">
						<div class="pro-name">Serial track</div>
						<div class="pro-value pstrack">0</div>
					</div>
					<!-- <?
						if ($_SESSION['member']['role'] == "Admin") {?>
							<div class="pro-container">
								<div class="pro-name">Cost Price</div>
								<div class="pro-value pcprice text-success">0</div>
							</div>
						<?}
					?> -->
					<!-- <div class="pro-container">
						<div class="pro-name">QuickSale Price</div>
						<div class="pro-value pqsprice text-success">0</div>
					</div> -->

				</div>
				<div class="pro-barcode">
					<div class="canvas-holder">
						<canvas class="brcodeholder_office" width="112" height="142"></canvas>
						<span class="barcode-name">Barcode</span>
					</div>
					<!-- <div class="canvas-holder">
						<canvas class="brcodeholder_manu" width="112" height="142"></canvas>
						<span class="barcode-name">manufacture Barcode</span>
					</div> -->
				</div>
				<div class="product-descption">
					<p id="product_desc_header"><strong>Product descption</strong></p>
					<p id="product_desc"></p>
				</div>
			</div>
			<div class="price_list_tbl">
				<table class="table table-hover mb-none" style="font-size:13px;" id="">
					<caption class="category_header">Product price List</caption>
					<thead>
						<tr>
							<th>#</th>
							<th>Level</th>
							<th>Exclusive Amount</th>
							<th>VAT</th>
							<th>Inclusive Amount</th>
							<th>Inclusive Amount (USD)</th>
						</tr>
					</thead>
					<tbody id="tbodyforpricelist">
					</tbody>
				</table>
			</div>
		</div>
		<div class="client_details_holder">
			<table class="table table-hover mb-none" style="font-size:13px;" id="purchase_client">
				<caption class="category_header">Client Details</caption>
				<thead>
					<tr>
						<th>#</th>
						<th>Client Name</th>
						<th>Invoice</th>
						<th>Purchase Date</th>
					</tr>
				</thead>
				<tbody id="purchase_client_list">
				
				</tbody>
			</table>
		</div>
		<div class="stock_details_holder">
			<table class="table table-hover mb-none" style="font-size:13px;" id="stock_tbl_list">
				<caption class="category_header">Stock Details</caption>
				<thead>
					<tr>
						<th>#</th>
						<th>Stock Location</th>
						<th>Quantity</th>
					</tr>
				</thead>
				<tbody id="stock_main_list">
				</tbody>
			</table>
		</div>
		<div class="button_tbl">
			<div onclick="openList('.product_details_holder','.client_details_holder','.stock_details_holder')" class="btn btn-primary">Product detail</div>
			<!-- <div onclick="openList('.stock_details_holder','.client_details_holder','.product_details_holder')" class="btn btn-primary">Stock List</div> -->
			<div onclick="openList('.client_details_holder','.product_details_holder','.stock_details_holder')" class="btn btn-primary">Purchase Client</div>
		</div>
		</div>
</div>
<!-- product screen end -->

<div class="col-md-12">
	<div class="center-panel">
		<section class="panel">
			<header class="panel-heading">
				<div class="row">
					<div class="col-md-3">
						<h2 class="panel-title">List of Products</h2>
						<p>Recently Added</p>
					</div>
					<div class="col-md-9 form-search">
						<form class="col-md-8">
							<input type="hidden" name="module" value="products">
							<input type="hidden" name="action" value="product_index">
							<!-- <div class="input-group input-search">
								<input type="text" class="form-control" placeholder="Enter search term" name="name" value="<?=$name?>"/>
								<span class="input-group-btn">
									<button class="btn btn-default" type="submit"><i class="fa fa-search"></i></button>
								</span>
							</div> -->
						</form>
						<a href="?module=products&action=product_add" class="mb-xs mt-xs mr-xs modal-with-zoom-anim btn"><i class="fa fa-plus"></i> Add Product</a>
						<a class="btn" href="?module=home&action=index"> <i class="fa fa-home"></i> Home</a>
					</div>
				</div>
			</header>
		<div class="panel-body">
				<div class="table-responsive">
					<table class="table table-hover mb-none" id="userTable">
			<thead>
				<tr>
					<th>No.</th>
					<th>Name</th>
					<th>Units</th>
					<th>Department</th>
					<th>VAT - (%)</th>
					<th>Status</th>
					<th>&nbsp;</th>
				</tr>
			</thead>
			<tbody>
				<?php foreach($product as $id=>$R) { ?>
					<tr>

						<td width="80px"><?=$id+1?></td>
						<td><?=$R['name']?></td>
						<td><?=$R['Unit']?></td>
						<td><?=$R['departmentName']?></td>
						<td><?=$R['categoryName']?> (<?=$R['vatPercent']?>%)</td>
						<td><?=$R['status']?></td>
						<td>
							<div class="btn-group dropleft">
								<button type="button" class="btn btn-secondary dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
							    <i class="fa fa-list"></i>
							  </button>
								<div class="dropdown-menu">
									<a class="dropdown-item" href="<?=url('products','product_edit','id='.$R['productid'])?>"  title="Edit"><i class="fa-pencil fa"></i> Edit Product</a>
									<?php if ($_SESSION['member']['roleid'] == R_ADMIN){?>
										<a class="dropdown-item" target="_blank" href="<?=url('products','product_admin','productid='.$R['id'])?>" title="Admin View"><i class="fa-arrow-circle-right fa"></i> Admin View</a>
									<?php }; ?>
									<a data-product_id="<?=$R['productid']?>" class="dropdown-item" onclick="getProductScreen(this)" href="#"  title="Product view"><i class="fa-eye fa"></i> Product View</a>
								</div>
							</div>
						</td>
					<?php } ?>
				</tbody>
			</table>
			</div>
	</div>
</div>
<script type="text/javascript">
function closeProductScreen(){
	$('.productpricelist').hide('slow');
}

$(document).keydown(function(event) {
    if (event.which === 27) {
    // alert('Alt + X pressed!');
    closeProductScreen();
    // e.preventDefault();
  }
});

function getProductScreen(obj){
	var productid = $(obj).attr('data-product_id');
	var stockid = $(obj).attr('data-product_stockid');
	var locationid = $('#locationid').val();
	$('.productpricelist').show('slow');

	$.get('?module=products&action=getProductPricesAndClients&format=json&productid='+productid+'&stockid='+stockid+'&stocklocation='+locationid,null,function(details){
		var product = eval(details);
		console.log(product);
		if (product[0].found == 'yes') {
			$('#tbodyforpricelist').empty();
			$('#purchase_client_list').empty();
			$('#stock_main_list').empty();
			var track = "";
			if(product[0].details.trackserialno == 1){
				track = 'Yes';
			}else{
				track = 'No';
			}


			// console.log(product[0][0]);

			$('.pname').html(product[0].details.productname);
			$('.pdepart').html(product[0].details.departname);
			$('.pcategory').html(product[0].details.categoryname);
			if (product[0].details.brand == null) {
				$('.pbrand').html("-");
			}else{
				$('.pbrand').html(product[0].details.brand);
			}
			$('.pvat').html(product[0].details.vat_rate);
			$('.pstrack').html(track);
			$('.pcprice').html(product[0].details.costprice);
			$('.pqsprice').html(product[0].details.quicksale_price);
			$('#product_desc').html(product[0].details.description);
			generateBarcode('.brcodeholder_office',product[0].details.barcode_office);
			// generateBarcode('.brcodeholder_manu',product[0].details.barcode_manufacture);

			$(product[0].priceLevel).each(function(index,level){
				count = parseInt(index) + 1;
				var vat_percent = product[0].details.vat_rate / 100;
				var vatAmount = vat_percent * level.suggested;
				let Inclusive = vatAmount + level.suggested;
				let usd = Inclusive/parseInt(product[0].usd_rate);

				var tableRow = "<tr>"+
				"<td>"+count+"</td><td>Level "+level.level+"</td>"+
				"<td>"+numberWithCommas(level.suggested)+"</td>"+
				"<td>"+product[0].details.vat_rate+"</td>"+
				"<td>"+numberWithCommas(Inclusive)+"</td>"+
				"<td>"+numberWithCommas(usd.toFixed(2))+"</td></tr>";
				$('#tbodyforpricelist').append(tableRow);
			});
			//client details
			$(product[0].clientList).each(function(index,list){
				count = parseInt(index) + 1;
				var tableRow = "<tr>"+
				"<td>"+count+"</td><td>"+list.clientname+"</td>"+
				"<td>"+list.invoiceno+"</td>"+
				"<td>"+list.purchase_date+"</td></tr>";
				$('#purchase_client_list').append(tableRow);
			});
			//stock details
			$(product[0].stock_list).each(function(index,list){
				count = parseInt(index) + 1;
				var tableRow = "<tr>"+
				"<td>"+count+"</td><td>"+list.stock_name+"</td>"+
				"<td>"+list.quantity+"</td></tr>";
				$('#stock_main_list').append(tableRow);
			});
		}
	});
}
function openList(openElement,closeElement1,closeElement2){
	$(openElement).show();
	$(closeElement1).hide();
	$(closeElement2).hide();
}
function generateBarcode(element,barcodedata){
	if (barcodedata != "") {
		JsBarcode(element , barcodedata, {
			displayValue:true
		});
	}
}
function numberWithCommas(number) {
	var parts = number.toString().split(".");
	parts[0] = parts[0].replace(/\B(?=(\d{3})+(?!\d))/g, ",");
	return parts.join(".");
}
</script>
