<!DOCTYPE html>
<html lang="en" dir="ltr">
  <head>
    <!-- <link href="https://fonts.googleapis.com/css?family=Alegreya+Sans&display=swap" rel="stylesheet"> -->
    <script src="assets/vendor/qrcodejs/qrcode.js"></script>
    <script src="assets/print-js/dist/print.js"></script>
    <link rel="stylesheet" type="text/css" href="assets/print-js/dist/print.css">
  </head>
<style>
  body {
    margin:0;
    font-family:"Helvetica Neue",Roboto,Arial,"Droid Sans",sans-serif;
    font-size:9px;
  }
  table{
    font-size:9px;
    color:black;
  }
  .receipt-container {
    width: 219px;
    margin: 0 auto;
    background:#ffffff;
    color:black;
  }
  .logobar img{
    width: 120px;
  }
  .logobar {
    width: 120px;
    margin: 0 auto;
}
  ul{
    list-style:none;
    padding:0;
    margin:0;
  }
  .details{
    margin-top:20px;
  }
  .company-details ul li,h4,h3{
    text-align:center;
    text-transform:uppercase;
  }
  #qrcode {
    width: 100%;
    margin: 0 auto;
  }
  #qrcode img {
    margin: 0 auto;
}
.normal-header {
    /* float: left; */
    display: block;
    width: 102px;
}
.normal {
    text-transform: uppercase;
}
.dashed-line{
  border-bottom:1px dashed
}
.receipt_tbl {
    width: 100%;
}
.receipt_tbl th {
    /* width: 80%; */
    text-align: left;
}
.product_tbl,.total_tbl {
  width: 100%;
  /* margin: 0 auto; */
}
.product_tbl,.total_tbl th {
    text-align: left;
}
.product_tbl td,.total_tbl td,.total_tbl th{
  padding: 8px;
  line-height: 1.42857143;
  vertical-align: top;
  border-top: 1px solid #ddd;
}
.nomargin {
  padding: 0;
  margin: 0;
  font-size:11px;
}
.receipt-code {
    padding-bottom: 20px;
}
.qrCodeHolder {
    padding-bottom: 20px;
}
.customer-details li{
  margin-top:8px;
}
.company-details ul li{
  text-align:center;
  font-size:8px;
}
#print_form_container{
  width:219px;
  padding:0;
}
.header-bar h3,.footer-bar h3{
  font-size:12px;
}
.ms-print-btn{
  right:38%;
}
</style>
<div class="ms-print-btn">
  <ul class="nav">
    <li class="nav-item">
      <button title="Print expenses form" onclick="printForm(form_holder)" class="btn btn-primary ms-btn ms-float-right" type="button" name="button"><i class="fa fa-print"></i></button>
    </li>
    <!-- <li class="nav-item item-top">
      <a title="Edit or add new expensess" href="<?=url('expenses','sales_expenses','id='.$salesid)?>" class="btn btn-success ms-btn ms-float-right"><i class="fa fa-edit"></i></a>
    </li> -->
  </ul>
</div>
<div id="print_form_container" class="receipt-container">
  <div id="form_holder">
    <div class="header-bar">
      <h3>**** START OF LEGAL RECEIPT ****</h3>
      <div class="logobar">
        <img src="assets/images/tra_logo.png" alt="tanzania revenue authority logo">
      </div>
    </div>
    <div class="details company-details">
      <h4><?=$settings['name']?></h4>
      <ul>
        <li><strong><?=$settings['address']?></strong></li>
        <li><strong>MOBILE:</strong> <?=$settings['mobile']?></li>
        <li><strong>TIN:</strong> <?=$settings['tin']?></li>
        <li><strong>VRN:</strong> <?=$settings['vrn']?></li>
        <li><strong>SERIAL NO:</strong> <?=$settings['vfd_serial']?></li>
        <li class="uin"><strong>UIN:</strong> <?=$settings['vfd_UIN']?></li>
        <li><strong>TAX OFFICE:</strong> Tax Office Ilala</li>
      </ul>
    </div>
    <div class="details dashed-line customer-details">
      <ul>
        <li><span class="normal-header"><strong>CUSTOMER NAME:</strong></span> <span class="normal"><?=$invoice[0]['clientname']?></span> </li>
        <li><span class="normal-header"><strong>CUSTOMER ID TYPE:</strong></span> <span class="normal">TAXPAYER INDETIFICATION NUMBER</span> </li>
        <li><span class="normal-header"><strong>CUSTOMER ID:</strong></span> <span class="normal"><?=$invoice[0]['clientino']?></span> </li>
        <li><span class="normal-header"><strong>CUSTOMER MOBILE:</strong></span> <span class="normal"><?=$invoice[0]['mobile']?></span> </li>
      </ul>
    </div>
    <div class="details dashed-line receipt-details">
      <table class="receipt_tbl">
        <tr>
          <th><strong>RECEIPT NO:</strong></th>
          <td align="right"><?=$invoice[0]['receipt_num']?></td>
        </tr>
        <tr>
          <th><strong>Z NUMBER:</strong></th>
          <td align="right"><?=$invoice[0]['vfdc']."/".$znum?></td>
        </tr>
        <tr>
          <th><strong>RECEIPT DATE:</strong></th>
          <td><?=date('Y-m-d',strtotime($invoice[0]['receipt_date']))?></td>
          <td><strong>TIME:</strong> <?=date('H:i:s',strtotime($invoice[0]['receipt_date']))?></td>
        </tr>
      </table>
    </div>
    <div class="details dashed-line product-details">
      <table class="product_tbl">
        <tr>
          <th>Description</th>
          <th align="center">Qty</th>
          <th align="right">Price</th>
        </tr>

        <?php foreach ($invoice as $key => $details){?>

          <tr>
            <td><?=$details['productname']?></td>
            <td align="center"><?=$details['quantity']?></td>
            <td align="right"><?=$details['price']?></td>
          </tr>

        <?php }; ?>

      </table>
      <table class="total_tbl">
        <tr>
          <th>SUBTOTAL:</th>
          <td align="right"><?=$invoice[0]['grand_amount']?></td>
        </tr>
        <tr>
          <th>TOTAL TAX:</th>
          <td align="right"><?=$invoice[0]['grand_vatamount']?></td>
        </tr>
        <tr>
          <th>TOTAL:</th>
          <td align="right"><?=$invoice[0]['full_amount']?></td>
        </tr>
      </table>
    </div>
    <div class="details dashed-line receipt-code">
      <h4 class="nomargin">RECEIPT VERIFICATION CODE</h4>
      <h3 class="nomargin"><strong><?=$settings['vfd_receiptCode'].$invoice[0]['receipt_num']?></strong></h3>
    </div>
    <div class="details dashed-line receipt_qr">
      <div class="qrCodeHolder">
        <div id="qrcode"></div>
      </div>
    </div>
    <div class="footer-bar">
      <h3>**** END OF LEGAL RECEIPT ****</h3>
      <div align="center">powercomputers LTD</div>
    </div>
  </div>
</div>
<script type="text/javascript">
$(function(){
  printForm('#form_holder');

  $('body').bind('copy cut paste', function(e){
    e.preventDefault();
  })

  $('body').on('contextmenu', function(e){
    return false;
  });

})
  var qrcode = new QRCode("qrcode", {
      text: "https://196.43.230.13/efdmsRctVerify/<?=$settings['vfd_receiptCode'].$invoice[0]['receipt_num']?>",
      width: 128,
      height: 128,
      colorDark : "#000000",
      colorLight : "#ffffff",
      correctLevel : QRCode.CorrectLevel.H
  });

  function printForm(areaToPrint){
    var id = $(areaToPrint).attr('id');
    printJS({
      printable:id,
      type: 'html',
      showModal: true,
      targetStyles: ['*']
    })
  }
  </script>
</html>
