<link rel="stylesheet" type="text/css" href="./assets/DataTables/datatables.min.css"/>
<script type="text/javascript" src="./assets/DataTables/datatables.min.js"></script>
<style media="screen">
  .for-column{
    width:100px;
  }
  .for-btn {
    padding: 16px;
    display: block;
	}
.for-holder{
	height:0px;
	overflow: hidden;
	transition: .3s;
	background: white;
}
.btn-holder {
  float: right;
}
.center-panel{
  width:70%;
  margin:0 auto;
}
.table .actions a:hover{
  color:#ffffff;
}
.table .actions a, .table .actions-hover a{
  color:#ffffff;
}
.type-indicate{
  width: 14px;
    height: 14px;
    border-radius: 100%;
    display: inline-block;
    position: absolute;
    right: 62%;
}
.type-indicate.color-on{
  background:#0088cc;
}
.type-indicate.color-off{
  background:#d64742;
}
.type-indicate.color-lunch{
  background:#d64742
}
.type-indicate.color-work{
  background:#47a447;
}
.paymentForm {
    height: 0;
    overflow: hidden;
    transition:.3s;
}
.open_payment_form{
  overflow:visible;
  height:424px;
  transition:.3s;
}
#saveBtn{
  display:none;
}
.row.row-color,.row-color-danger {
    background: #0088cc;
    color: #ffffff;
    padding: 10px;
}
.row-color-danger{
  background: #d2322d;
}
.row-color h5,.row-color-danger h5 {
    font-size: 18px;
    padding: 0;
    margin-bottom: 0;
    text-align: center;
    text-transform: uppercase;
}
.badge-paid {
    font-size: 19px;
    text-align: center;
    display: block;
    padding-top: 10px;
    font-weight: 100;
}
#salesamount_cash{
  display:none;
}
.badge-case{
  text-transform:capitalize;
}
#forcheque,#forbank,#forReceipt{
  display:none;
}
</style>
<header class="page-header">
	<h2>Sales Payment</h2>
</header>
<div class="center-panel">
	<section class="panel">
		<header class="panel-heading for-heading">
			<div class="btn-holder">
  			<a class="btn btn-cog" href="<?=$_SERVER['HTTP_REFERER']?>"> <i class="fa fa-list"></i> Back to List</a>
  			<a class="btn btn-cog" href="?module=home&action=index"> <i class="fa fa-home"></i> Home</a>

        <?php if ($pay_status != 'complete'){?>

          <?php if ($totalpaid[0]['totalpaid'] != $full_amount){?>
            <a id="control_payment_form" class="btn btn-cog" href="#"> <i class="fa fa-money"></i>
              <span class="symbol">Make Payment - Show</span>
            </a>
          <?php }?>

        <?php }; ?>

      </div>
			<h2 class="panel-title"><i class="fa fa-money"></i> Payment</h2>
		</header>
	<div class="panel-body">

    <?php if ($pay_status != 'complete'){?>

      <?php if ($totalpaid[0]['totalpaid'] != $full_amount){?>

        <div id="payment_form" class="paymentForm <?if($_GET['form'] == 'open') echo 'open_payment_form';?>" >
          <form  id="form" class="form-horizontal form-bordered" method="post" action="<?=url('payments','save_payment')?>">
            <div class="row">
              <div class="col-md-6">
                <h5>Total paid</h5>
                <input id="tpaid" class="form-control" readonly type="text" name="" value="<?=formatN($totalpaid[0]['totalpaid'])?>">
              </div>
              <div class="col-md-6">
                <h5>Full Amount</h5>
                <input id="gtotal" class="form-control" readonly type="text" name="" value="<?=formatN($full_amount)?>">
              </div>
            </div>
            <div class="row">
              <div class="col-md-12">
                <h5>Client Name</h5>
                <input id="clientid" type="hidden" name="payment[clientid]" value="<?=$clientid;?>">
                <input id="salesid" type="hidden" name="salesid" value="<?=$salesid;?>">
                <input id="clientidname" class="form-control" readonly type="text" name="clientname" value="<?=$clientname;?>">
              </div>
            </div>
            <div class="row">
              <div class="col-md-6">
                <h5>Amount to Pay</h5>
                <input type="hidden" name="receipt_method" value="<?=$receipt?>"/>
                <input readonly max="<?if($totalpaid[0]['totalpaid']) echo $full_amount - $totalpaid[0]['totalpaid'];  else echo $full_amount?>" id="salesamount_cash" onkeyup="paymentAmount(this)" required title="Amount" required placeholder="Payment Amount" type="number" class="form-control" name="amount"
                value="<?if($totalpaid[0]['totalpaid']) echo $full_amount - $totalpaid[0]['totalpaid'];  else echo $full_amount?>">

                <input max="<?if($totalpaid[0]['totalpaid']) echo $full_amount - $totalpaid[0]['totalpaid'];  else echo $full_amount?>" id="salesamount" onkeyup="paymentAmount(this)" required title="Amount" required placeholder="Payment Amount" type="number" class="form-control" name="amount"
                value="<?=$payment['amount'];?>">
              </div>
              <div class="col-md-6">
                <h5>Payment Method</h5>
                <input id="paymentMname" type="hidden" name="methodname" value="">
                <select id="pmethod" onchange="getPaymentMethod(this);" required title="payment method" class="form-control" name="payment[pmethod_id]">
                  <!-- <option selected disabled>-Choose Method-</option> -->
                  <?php foreach ($paymentmethod as $key => $method){?>
                    <option <?=selected($method['name'],'Cash')?> value="<?=$method['id'];?>"><?=$method['name'];?></option>
                  <?php }; ?>
                </select>
              </div>
            </div>
            <div class="row" id="forReceipt">
              <div class="col-md-12">
                <h5>Receipt Type</h5>
                <select class="form-control" name="receipt_type">
                  <option selected disabled>--Choose Type--</option>
                  <option value="efd">Electronic Fiscal Device (EFD)</option>
                  <option value="vfd">Virtual Fiscal Device (VFD)</option>
                  <option value="normal">Normal receipt</option>
                </select>
              </div>
            </div>
            <div class="row" id="forcheque">
              <div class="col-md-12">
                <h5>Cheque Number</h5>
                <input id="chequename" required placeholder="Cheque Number" class="form-control" type="text" name="payment[chequename]" value="">
              </div>
            </div>
            <div class="row" id="forbank">
              <div class="col-md-6">
                <h5>Bank Name</h5>
                <input id="bankname" required placeholder="Bank Name" class="form-control" type="text" name="payment[bankname]" value="">
              </div>
              <div class="col-md-6">
                <h5>Bank References/Ac.</h5>
                <input id="bankreference" required placeholder="Bank References" class="form-control" type="text" name="payment[bankreference]" value="">
              </div>
            </div>
            <div class="row">
              <div class="col-md-12">
                <h5>Payment Remark</h5>
                <textarea id="payment_remark" placeholder="Remarks" name="payment[remark]" class="form-control" rows="2" cols="80"></textarea>
              </div>
            </div>
            <div class="form-group">
              <div id="saveBtn" class="col-md-12">
                <button type="submit" class="mb-xs mt-xs mr-xs btn btn-primary btn-block"><i class="fa fa-save"></i> Save Payment</button>
              </div>
            </div>
          </form>
        </div>

      <?php }else{ ?>

        <div class="row-paid">
          <div class="row row-color-danger">
            <div class="col-md-4">
              <h5>Paid Total Amount</h5>
              <span class="badge-paid"><i class="fa fa-money"></i> <?=formatN($totalpaid[0]['totalpaid'])?></span>
            </div>
            <div class="col-md-4">
              <h5>Payment Status</h5>
              <span class="badge-paid badge-case"><i class="fa fa-thumbs-up"></i> <?=$pay_status?></span>
            </div>
            <div class="col-md-4">
              <h5>Invoice Total Amount</h5>
              <span class="badge-paid"><i class="fa fa-money"></i> <?=formatN($full_amount)?></span>
            </div>
          </div>
        </div>

      <?php } ?>

    <?php }else{ ?>

      <div class="row-paid">
        <div class="row row-color">
          <div class="col-md-4">
            <h5>Paid Total Amount</h5>
            <span class="badge-paid"><i class="fa fa-money"></i> <?=formatN($totalpaid[0]['totalpaid'])?></span>
          </div>
          <div class="col-md-4">
            <h5>Payment Status</h5>
            <span class="badge-paid badge-case"><i class="fa fa-thumbs-up"></i> <?=$pay_status?></span>
          </div>
          <div class="col-md-4">
            <h5>Invoice Total Amount</h5>
            <span class="badge-paid"><i class="fa fa-money"></i> <?=formatN($full_amount)?></span>
          </div>
        </div>
      </div>

    <?php }; ?>

		<div class="table-responsive">
			<table class="table table-hover mb-none" id="amcTable" style="font-size:13px">
				<thead>
					<tr>
						<th><i class="fa fa-hashtag"></i> SN</th>
						<th title="Transaction Number"><i class="fa fa-check"></i> Trans. No.</th>
						<th><i class="fa fa-credit-card"></i> Method</th>
            <th><i class="fa fa-money"></i> Amount</th>
						<th style="text-align:center"><i class="fa fa-calendar"></i> Paid On/Issued date</th>
						<th style="text-align:center;" title="Transaction Status"><i class="fa fa-check"></i> Trans. Status</th>

            <?php if ($open_verifier){?>
              <th><i class="fa fa-check"></i> </th>
            <?php }; ?>

					</tr>
				</thead>
				<tbody>

          <?php if (empty($payments)){?>
            <!-- <span class="type-indicate color-off"></span> -->
            <p style="color:red">No payment yet.. </p>
          <?php }else{?>
            <?php foreach($payments as $id=>$R) { ?>
  						<tr>
  							<td width="80px"><?=$id+1?></td>
                <td width="80px"><?=$R['id']?></td>
                <td style="text-transform:uppercase"><?=$R['method']?></td>
                <td style="text-align:center"><?=formatN($R['amount'])?></td>
                <td style="text-align:center"><?=fDate($R['doc'])?></td>
                <td style="text-align:center;text-transform:capitalize"><?=$R['sp_status']?></td>

                <?php if ($open_verifier){?>
                  <td>

                    <?php if ($R['sp_status'] == 'inactive'){?>
                      <a href=<?=url('payments','payment_aproval','pyt='.base64_encode('@'.$R['id'].'@'))?> title="Verify the Transaction" class="btn btn-success"><i class="fa fa-check"></i></a>
                    <?php }else{ ?>
                      <button title="Transaction is Verified" type="button" name="button" class="btn"><i class="fa fa-ban"></i></button>
                    <?php } ?>

                  </td>
                <?php }; ?>

              </tr>
  						<?php } ?>
          <?php }; ?>

					</tbody>
				</table>
		</div>
    <script type="text/javascript">
    $(function(){
      <?if($_GET['form'] == 'open'){?>
        $('#salesamount').focus();
      <?}?>
      getPaymentMethod('#pmethod');
    })

    function getPaymentMethod(obj){
      var mthodid = $(obj).val();
      var id = $(obj).attr('id');
      var name = $("#"+id+" option:selected").text();
      $('#paymentMname').val(name);
      if(name == 'Cash'){
        $('#salesamount_cash').show().removeAttr('disabled');
        $('#salesamount').hide().attr('disabled','disabled');
        $('#saveBtn').show();
        $('#forReceipt').show();
        $('#forbank').hide();
        $('#forcheque').hide();
        // $('#payment_remark').attr('required','required');
      }else if(name == 'bank'){
        $('#salesamount_cash').hide().attr('disabled','disabled');
        $('#salesamount').show().removeAttr('disabled');
        $('#forbank').show();
        $('#forcheque').hide();
        $('#forReceipt').hide();
        // $('#payment_remark').removeAttr('required');
        triggerError('Bank details required');
      }else if(name == 'cheque'){
        $('#salesamount_cash').hide().attr('disabled','disabled');
        $('#salesamount').show().removeAttr('disabled');
        $('#forcheque').show();
        $('#forbank').hide();
        $('#forReceipt').hide();
        // $('#payment_remark').removeAttr('required');
        triggerError('Cheque details required')
      }else{
        $('#salesamount_cash').hide().attr('disabled','disabled');
        $('#salesamount').show().removeAttr('disabled');
        $('#saveBtn').hide();
        // $('#payment_remark').removeAttr('required');
      }
    }

    $('#control_payment_form').on('click', function(){
      $('#payment_form').toggleClass('open_payment_form');
      if($('#payment_form').hasClass('open_payment_form') == true){
        $('#control_payment_form').find('.symbol').text('Make Payment - Show');
      }else{
        $('#control_payment_form').find('.symbol').text('Make Payment - Hide');
      }
    })

      function paymentAmount(obj){
        var amount = $(obj).val();
        var max = $(obj).attr('max');
        if(amount == '' || amount == null){
          $('#saveBtn').hide('slow');
        }else{
          if(parseInt(amount) > parseInt(max)){
            triggerError('Amount is exceed the Grand total');
            $('#saveBtn').hide('slow');
          }else{
            $('#saveBtn').show('slow');
          }
        }
      }

      <?php if($_GET['print']){ ?>
        window.open('?module=sales&action=print_taxinvoice&salesno=<?=$salesid?>', '_blank');
      <?  } ?>

      <?php if($_GET['print']){ ?>
        window.open('?module=pos&action=print_sr_receipt&id=<?=$salesid?>', '_blank');
      <?  } ?>

    </script>
