<link rel="stylesheet" type="text/css" href="./assets/DataTables/datatables.min.css"/>
<script type="text/javascript" src="./assets/DataTables/datatables.min.js"></script>
<style media="screen">
div.dataTables_wrapper div.dataTables_filter input {
    width: 100%;
}
div.dataTables_wrapper div.dataTables_filter input{
  margin-left:0;
}
.panel-actions a, .panel-actions .panel-action{
	font-size: 21px;
}
.formholder h5 {
    font-size: 15px;
    font-weight: 600;
}
.for-input {
  padding: 8px;
  height: 40px;
  font-size: 14px;
  border: none;
  outline: none;
	margin-top: 2px;
}
.select2-container--default .select2-selection--single{
  padding: 8px;
  height: 40px;
  font-size: 14px;
	border: none;
	outline: none;
	margin-top: 2px;
}
.formModel {
	display:none;
	position: fixed;
	width: 100%;
	z-index: 14;
	background: rgba(238, 238, 238, 0.6196078431372549);
	top: 0;
	left: 0;
	right: 0;
	bottom: 0;
	height: 100%;
}
.formholder {
	position: relative;
	display:none;
	z-index: 26;
	border-radius: 5px;
	padding: 24px;
  width: 72%;
  margin: 0 auto;
	background: #ededee;
	height: auto;
	/* -webkit-box-shadow: 0px 4px 33px -4px rgba(0,0,0,0.41);
	-moz-box-shadow: 0px 4px 33px -4px rgba(0,0,0,0.41);
	box-shadow: 0px 4px 33px -4px rgba(0,0,0,0.41); */
  -webkit-box-shadow: 0 25px 65px rgba(15, 24, 33, 0.29);
  box-shadow: 0 25px 65px rgba(15, 24, 33, 0.29);
	}
.panelControl {
    float: right;
}
.for-formanage {
    border: 1px solid #47a447;
    padding: 9px;
    height: auto;
    border-radius: 5px;
}
.dropleft .dropdown-menu {
  top: 0;
  right: 100%;
  left: auto;
  margin-top: 0;
  margin-right: .125rem;
}
a.dropdown-item{
	text-decoration:none;
}
.dropdown-item {
  display: block;
  width: 100%;
  padding: .25rem 1.5rem;
  clear: both;
  font-weight: 400;
  color: #212529;
  text-align: inherit;
  white-space: nowrap;
  background-color: transparent;
  border: 0;
}
.ticketholder {
  position: fixed;
  z-index: 99;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background: rgba(0, 0, 0, 0.5803921568627451);
  display: none;
}
.table-holder {
  position: relative;
  top: 159px;
  background: white;
  width: 88%;
  margin: 0 auto;
  margin-left: 121px;
}
.title-model {
  padding-top: 4px;
  float: left;
  margin-left: 26px;
}
.close-btn-holder {
  right: 0;
  top: -41px;
  position: absolute;
  background: white;
  padding: 10px;
}
.table-responsive {
  min-height: 223px;
}
.center-panel {
  width: 91%;
  margin: 0 auto;
}
.redborder{
	border: solid #ff0000 3px !important;
	background: #ff0000 !important;
}
</style>

<div id="formModel" class="formModel"></div>
<div id="formHolder" class="formholder">
	<h5>Search Query</h5>
	<form>
		<input type="hidden" name="module" value="reports">
		<input type="hidden" name="action" value="product_history">
		<div id="filter_table">
			<div class="row">
        <div class="col-md-6">
					<select id="locationid" class="form-control for-input select2" name="location">
						<!-- <option value="" ><?=$_GET['location']?></option> -->
						<? foreach ($locations as $loc){?>
							<option value="<?=$loc['id']?>" <?if($_GET['location'] == $loc['id']){echo "selected";}?>> <?=$loc['name']?></option>
						<?}?>
					</select>
				</div>
				<div class="col-md-6">
					<select id="productid" class="form-control" name="productid">
						<?
							if (empty($_GET['productid'])) {?>
								<option selected="" disabled="">Select Product</option>	
							<?}
						?>
						<? foreach ($products as $p){?>
							<option value="<?=$p['id']?>" <?if($_GET['productid'] == $p['id']){echo "selected";}?>> <?=$p['name']?></option>
						<?}?>
					</select>
				</div>
			</div>
			<div class="row">
				<div class="col-md-6">
					<div class="row">
						<div class="col-md-4">
							<h5>From Date</h5>
						</div>
						<div class="col-md-8">
							<input type="text" readonly name="fromdate"  class="datepicker form-control for-input" value="<?=$fromdate?>">
						</div>
					</div>
				</div>
				<div class="col-md-6">
					<div class="row">
						<div class="col-md-4">
							<h5>To Date</h5>
						</div>
						<div class="col-md-8">
							<input type="text" readonly name="todate"  class="datepicker form-control for-input" value="<?=$todate?>">
						</div>
					</div>
				</div>
			</div>
			<div class="row">
        <div class="col-md-4">
					<div id="closeSearchModel" class="btn btn-danger btn-block"><i CLASS="fa fa-close"></i> CANCEL</div>
				</div>
				<div class="col-md-4">
					<a href="?module=reports&action=product_history" class="btn btn-success btn-block"><i class="fa fa-minus"></i> RESET</a>
				</div>
        <div class="col-md-4">
					<button type="submit" class="btn btn-primary btn-block" name="button"><i class="fa fa-search"></i> SEARCH</button>
				</div>
			</div>
		</div>
	</form>
</div>

<div class="center-panel">
	<section class="panel">
		<header class="panel-heading">
			<div class="panelControl">
				<a id="openModel" class="btn" href="#" title="Filter"> <i class="fa fa-search"></i> Open filter </a>
				<a class="btn" href="?module=home&action=index" title="Home"> <i class="fa fa-home"></i> Home</a>
			</div>
			<h2 class="panel-title">Product history report</h2>
		</header>
		<div class="panel-body">
			<div class="table-responsive">
        <div class="search-details">
          <h4>FOR: <strong><?=$product['name']?></strong> </h4>
          <h5>Location: <strong><?=$location['name']?></strong> </h5>
          <!-- <h5>Current stock: <strong><?=$current_balance[0]['total']?></strong> </h5> -->
        </div>
				<table class="table table-hover mb-none" style="font-size:13px;" id="printisng_area">
					<thead>
            <tr>
              <th>#</th>
              <th>DATE</th>
              <th>VOUCHER TYPE</th>
              <th>VOUCHER NO.</th>
              <th>QTY IN</th>
              <th>QTY OUT</th>
              <th>BALANCE</th>
            </tr>
					</thead>
					<tbody>
            <?$count=1?>
            <tr><td colspan=6 style="text-align:right">Opening balance</td><td><?=$endTotal?></td></tr>
            <?php foreach ($product_history as $index => $product_row){?>
              <?php foreach ($product_row as $v => $group_row){ ?>
                <?php foreach ($group_row as $key => $final_row){ ?>

                  <?

                      if ($final_row['flow'] == 'in') {
                        $endTotal = $endTotal + $final_row['quantity'];
                        $totalIn += $final_row['quantity'];
                      }else {
                        $endTotal = $endTotal - $final_row['quantity'];
                        $totalOut += $final_row['quantity'];
                      }

                  ?>

                  <tr>
                    <td><?=$count++?></td>
                    <td><?=$final_row['date']?></td>
                    <td><?=$final_row['voucher type']?></td>
                    <td><?=$final_row['voucher no']?></td>
                    <td><?if($final_row['flow'] == 'in') echo formatN($final_row['quantity'],0); else echo '0';?></td>
                    <td><?if($final_row['flow'] == 'out') echo formatN($final_row['quantity'],0); else echo '0';?></td>
                    <td><strong><?=$endTotal?></strong></td>
                  </tr>

                <?php }; ?>
              <?php }; ?>
            <?php }; ?>

            <tr style="background: #888; color: #fff;">
              <td></td>
              <td></td>
              <td></td>
              <td></td>
        			<td><?=$totalIn?></td>
        			<td><?=$totalOut?></td>
        			<td><strong><?=formatN($endTotal,0)?></strong></td>
        		</tr>

					</tbody>
				</table>
			</div>
		</div>
	</section>
</div>
<script type="text/javascript">
$(function(){

  $('#_locationid').select2({width:'100%',minimumInputLength:3,ajax:{
		url:"?module=locations&action=getLocations&format=json",dataType:'json',delay:250,quietMillis:200,
		data: function (term) {return {search:term};},
		results:function (data,page){return{result:data};}
	}});

  $('#_productid').select2({width:'100%',minimumInputLength:3,ajax:{
		url:"?module=products&action=getProducts&format=json",dataType:'json',delay:250,quietMillis:200,
		data: function (term) {return {search:term};},
		results:function (data,page){return{result:data};}
	}});
})

$('#openModel').on('click', function (){
	$('#formHolder').show('slow');
	$('#formModel').show('slow');
	/*$('html, body').css({
    overflow: 'hidden',
    height: '100%'
	});*/
})

$('#closeSearchModel').on('click', function (){
	$('#formHolder').hide('slow');
	$('#formModel').hide('slow');
	/*$('html, body').css({
    overflow: 'auto',
    height: 'auto'
	});*/
})

<?
	if ($openfilter == 1 ) {?>
		$(document).ready(function(){
			$('#formHolder').show('slow');
			$('#formModel').show('slow');
			// $('#productid').addClass('redborder')
		});	
	<?}
?>



$(document).ready(function(){
 $('#printing_area').DataTable({
	 dom: '<"top"fB>t<"bottom"ip>',
	 colReorder:true,
	 keys:true,
	 buttons: ['excelHtml5', 'pdfHtml5','print'],
	 <?if($_GET['status']){?>
	 title:'<?=$_GET['status']?>',
	 <?}?>
 });
})

</script>
