<link rel="stylesheet" type="text/css" href="./assets/DataTables/datatables.min.css"/>
<script type="text/javascript" src="./assets/DataTables/datatables.min.js"></script>
<style media="screen">
div.dataTables_wrapper div.dataTables_filter input {
    width: 100%;
}
div.dataTables_wrapper div.dataTables_filter input{
  margin-left:0;
}
.panel-actions a, .panel-actions .panel-action{
	font-size: 21px;
}
.formholder h5 {
    font-size: 15px;
    font-weight: 600;
}
.for-input {
  padding: 8px;
  height: 40px;
  font-size: 14px;
  border: none;
  outline: none;
	margin-top: 2px;
}
.select2-container--default .select2-selection--single{
  padding: 8px;
  height: 40px;
  font-size: 14px;
	border: none;
	outline: none;
	margin-top: 2px;
}
.formModel {
	display:none;
	position: fixed;
	width: 100%;
	z-index: 14;
	background: rgba(238, 238, 238, 0.6196078431372549);
	top: 0;
	left: 0;
	right: 0;
	bottom: 0;
	height: 100%;
}
.formholder {
	position: relative;
	display:none;
	z-index: 26;
	border-radius: 5px;
	padding: 24px;
  width: 72%;
  margin: 0 auto;
	background: #ededee;
	height: auto;
	/* -webkit-box-shadow: 0px 4px 33px -4px rgba(0,0,0,0.41);
	-moz-box-shadow: 0px 4px 33px -4px rgba(0,0,0,0.41);
	box-shadow: 0px 4px 33px -4px rgba(0,0,0,0.41); */
  -webkit-box-shadow: 0 25px 65px rgba(15, 24, 33, 0.29);
  box-shadow: 0 25px 65px rgba(15, 24, 33, 0.29);
	}
.panelControl {
    float: right;
}
.for-formanage {
    border: 1px solid #47a447;
    padding: 9px;
    height: auto;
    border-radius: 5px;
}
.dropleft .dropdown-menu {
  top: 0;
  right: 100%;
  left: auto;
  margin-top: 0;
  margin-right: .125rem;
}
a.dropdown-item{
	text-decoration:none;
}
.dropdown-item {
  display: block;
  width: 100%;
  padding: .25rem 1.5rem;
  clear: both;
  font-weight: 400;
  color: #212529;
  text-align: inherit;
  white-space: nowrap;
  background-color: transparent;
  border: 0;
}
.ticketholder {
  position: fixed;
  z-index: 99;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background: rgba(0, 0, 0, 0.5803921568627451);
  display: none;
}
.table-holder {
  position: relative;
  top: 159px;
  background: white;
  width: 88%;
  margin: 0 auto;
  margin-left: 121px;
}
.title-model {
  padding-top: 4px;
  float: left;
  margin-left: 26px;
}
.close-btn-holder {
  right: 0;
  top: -41px;
  position: absolute;
  background: white;
  padding: 10px;
}
.table-responsive {
  min-height: 223px;
}
.center-panel {
  width: 91%;
  margin: 0 auto;
}
</style>

<div id="formModel" class="formModel"></div>
<div id="formHolder" class="formholder">
	<h5>Search Query</h5>
	<form>
		<input type="hidden" name="module" value="reports">
		<input type="hidden" name="action" value="audit_report">
		<div id="filter_table">
			<!-- <div class="row">
        <div class="col-md-6">
					<select id="locationid" class="form-control for-input" name="location">
							<option value="" selected disabled>Store location</option>
							<? foreach ($locations as $loc){?>
								<option <?=selected($loc['id'],$user)?> value="<?=$loc['id']?>"><?=$loc['name']?></option>
							<?}?>
						</select>
				</div>
				<div class="col-md-6">
					<select id="productid" class="form-control" name="productid">
						<?php if ($client){?>
							<option value="<?=$client['id']?>"><?=$client['name']?></option>
						<?php }else {?>
							<option value="" selected disabled>Product name</option>
						<?php }?>
					</select>
				</div>
			</div> -->
			<div class="row">
				<div class="col-md-6">
					<div class="row">
						<div class="col-md-4">
							<h5>From Date</h5>
						</div>
						<div class="col-md-8">
							<input type="text" readonly name="fromdate"  class="datepicker form-control for-input" value="<?=$fromdate?>">
						</div>
					</div>
				</div>
				<div class="col-md-6">
					<div class="row">
						<div class="col-md-4">
							<h5>To Date</h5>
						</div>
						<div class="col-md-8">
							<input type="text" readonly name="todate"  class="datepicker form-control for-input" value="<?=$todate?>">
						</div>
					</div>
				</div>
			</div>
			<div class="row">
        <div class="col-md-4">
					<div id="closeSearchModel" class="btn btn-danger btn-block"><i CLASS="fa fa-close"></i> CANCEL</div>
				</div>
				<div class="col-md-4">
					<a href="?module=reports&action=product_history" class="btn btn-success btn-block"><i class="fa fa-minus"></i> RESET</a>
				</div>
        <div class="col-md-4">
					<button type="submit" class="btn btn-primary btn-block" name="button"><i class="fa fa-search"></i> SEARCH</button>
				</div>
			</div>
		</div>
	</form>
</div>

<div class="center-pasnel">
	<section class="panel">
		<header class="panel-heading">
			<div class="panelControl">
				<a id="openModel" class="btn" href="#" title="Filter"> <i class="fa fa-search"></i> Open filter </a>
				<a class="btn" href="?module=home&action=index" title="Home"> <i class="fa fa-home"></i> Home</a>
			</div>
			<h2 class="panel-title">Sales audit report</h2>
		</header>
		<div class="panel-body">
			<div class="table-responsive">
        <!-- <div class="search-details">
          <h4>FOR: <strong><?=$product['name']?></strong> </h4>
          <h5>Location: <strong><?=$location['name']?></strong> </h5>
        </div> -->
				<table class="table table-hover mb-none" style="font-size:13px;" id="printing_area">
					<thead>
            <tr>
              <th>#</th>
              <th>User/Staff</th>
              <th>Date</th>
              <th>Trans. No</th>
              <th>Trans. type</th>
              <th>Cusotmer name</th>
              <th>Product name</th>
              <th>Description</th>
              <th>Currency</th>
              <th>Unit Price</th>
              <th>Qty</th>
              <!-- <th>Unit sold</th> -->
              <th>Amount Inc</th>
              <th>VAT (%)</th>
              <th>Cost</th>
              <!-- <th>Cost Exc</th> -->
              <th>Margin (%)</th>
            </tr>
					</thead>
					<tbody>
            <?$count=1?>

            <?php foreach ($sales_audit as $key => $sales){ ?>
              <tr>
                <td><?=$count++?></td>
                <td><?=$sales['salesperson']?></td>
                <td><?=$sales['createdate']?></td>
                <td><?=$sales['salesid']?></td>
                <td><?='Invoice'?></td>
                <td><?=$sales['clientname']?></td>
                <td><?=$sales['productname']?></td>
                <td><?=$sales['description']?></td>
                <td><?=$sales['currencyname']?></td>
                <td><?=$sales['amount']?></td>
                <td><?=$sales['quantity']?></td>
                <td><?=$sales['amount']*$sales['quantity']+$sales['vat_amount']?></td>
                <td><?=$sales['vat_rate']?></td>
                <td><?=$sales['hidden_cost']?></td>
                <td><?=formatN($sales['margin_percent'],1)?></td>
              </tr>
            <?php }; ?>

					</tbody>
				</table>
			</div>
		</div>
	</section>
</div>
<script type="text/javascript">
$(function(){
  $('#locationid').select2({width:'100%',minimumInputLength:3,ajax:{
		url:"?module=locations&action=getLocations&format=json",dataType:'json',delay:250,quietMillis:200,
		data: function (term) {return {search:term};},
		results:function (data,page){return{result:data};}
	}});
  $('#productid').select2({width:'100%',minimumInputLength:3,ajax:{
		url:"?module=products&action=getProducts&format=json",dataType:'json',delay:250,quietMillis:200,
		data: function (term) {return {search:term};},
		results:function (data,page){return{result:data};}
	}});

//   $('#printing_area').DataTable({
//     dom: '<"top"fB>t<"bottom"ip>',colReorder:true,keys:true,buttons: ['excelHtml5', 'pdfHtml5','print']
//   });
})

$('#openModel').on('click', function (){
	$('#formHolder').show('slow');
	$('#formModel').show('slow');
	/*$('html, body').css({
    overflow: 'hidden',
    height: '100%'
	});*/
})

$('#closeSearchModel').on('click', function (){
	$('#formHolder').hide('slow');
	$('#formModel').hide('slow');
	/*$('html, body').css({
    overflow: 'auto',
    height: 'auto'
	});*/
})

</script>
