<link rel="stylesheet" type="text/css" href="./assets/DataTables/datatables.min.css"/>
<script type="text/javascript" src="./assets/DataTables/datatables.min.js"></script>
<style media="screen">
div.dataTables_wrapper div.dataTables_filter input {
    width: 100%;
}
div.dataTables_wrapper div.dataTables_filter input{
  margin-left:0;
}
.panel-actions a, .panel-actions .panel-action{
	font-size: 21px;
}
.formholder h5 {
    font-size: 15px;
    font-weight: 600;
}
.for-input {
  padding: 8px;
  height: 40px;
  font-size: 14px;
  border: none;
  outline: none;
	margin-top: 2px;
}
.select2-container--default .select2-selection--single{
  padding: 8px;
  height: 40px;
  font-size: 14px;
	border: none;
	outline: none;
	margin-top: 2px;
}
.formModel {
	display:none;
	position: fixed;
	width: 100%;
	z-index: 14;
	background: rgba(238, 238, 238, 0.6196078431372549);
	top: 0;
	left: 0;
	right: 0;
	bottom: 0;
	height: 100%;
}
.formholder {
	position: relative;
	display:none;
	z-index: 26;
	border-radius: 5px;
	padding: 24px;
  width: 72%;
  margin: 0 auto;
	background: #ededee;
	height: auto;
	-webkit-box-shadow: 0px 4px 33px -4px rgba(0,0,0,0.41);
	-moz-box-shadow: 0px 4px 33px -4px rgba(0,0,0,0.41);
	box-shadow: 0px 4px 33px -4px rgba(0,0,0,0.41);
	}
.panelControl {
    float: right;
}
.for-formanage {
    border: 1px solid #47a447;
    padding: 9px;
    height: auto;
    border-radius: 5px;
}
.dropleft .dropdown-menu {
  top: 0;
  right: 100%;
  left: auto;
  margin-top: 0;
  margin-right: .125rem;
}
a.dropdown-item{
	text-decoration:none;
}
.dropdown-item {
  display: block;
  width: 100%;
  padding: .25rem 1.5rem;
  clear: both;
  font-weight: 400;
  color: #212529;
  text-align: inherit;
  white-space: nowrap;
  background-color: transparent;
  border: 0;
}
.ticketholder {
  position: fixed;
  z-index: 99;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background: rgba(0, 0, 0, 0.5803921568627451);
  display: none;
}
.table-holder {
  position: relative;
  top: 159px;
  background: white;
  width: 88%;
  margin: 0 auto;
  margin-left: 121px;
}
.title-model {
  padding-top: 4px;
  float: left;
  margin-left: 26px;
}
.close-btn-holder {
  right: 0;
  top: -41px;
  position: absolute;
  background: white;
  padding: 10px;
}
.table-responsive {
  min-height: 223px;
}
.center-panel {
  width: 68%;
  margin: 0 auto;
}
</style>
<header class="page-header">
	<h2>Daily Cash Report</h2>
</header>

<div id="formModel" class="formModel"></div>
<div id="formHolder" class="formholder">
	<h5>Search Query</h5>
	<form>
		<input type="hidden" name="module" value="reports">
		<input type="hidden" name="action" value="daily_cash">
		<div id="filter_table">
			<div class="row">
				<div class="col-md-6">
					<select id="clientid" class="form-control" name="client">
						<?php if ($client){?>
							<option value="<?=$client['id']?>"><?=$client['name']?></option>
						<?php }else {?>
							<option value="" selected disabled>Client Name</option>
						<?php }?>
					</select>
				</div>
				<div class="col-md-6">
					<select class="form-control for-input" name="user">
							<option value="" selected disabled>Sales person</option>
							<? foreach ($users as $r){?>
								<option <?=selected($r['id'],$user)?> value="<?=$r['id']?>"><?=$r['name']?></option>
							<?}?>
						</select>
				</div>
			</div>
			<div class="row">
				<div class="col-md-6">
					<div class="row">
						<div class="col-md-4">
							<h5>From Date</h5>
						</div>
						<div class="col-md-8">
							<input type="text" readonly name="fromdate"  class="datepicker form-control for-input" value="<?=$fromdate?>">
						</div>
					</div>
				</div>
				<div class="col-md-6">
					<div class="row">
						<div class="col-md-4">
							<h5>To Date</h5>
						</div>
						<div class="col-md-8">
							<input type="text" readonly name="todate"  class="datepicker form-control for-input" value="<?=$todate?>">
						</div>
					</div>
				</div>
			</div>
			<div class="row">
        <div class="col-md-4">
					<div id="closeSearchModel" class="btn btn-danger btn-block"><i CLASS="fa fa-close"></i> CANCEL</div>
				</div>
				<div class="col-md-4">
					<a href="?module=reports&action=daily_cash" class="btn btn-success btn-block"><i class="fa fa-minus"></i> RESET</a>
				</div>
        <div class="col-md-4">
					<button type="submit" class="btn btn-primary btn-block" name="button"><i class="fa fa-search"></i> SEARCH</button>
				</div>
			</div>
		</div>
	</form>
</div>

<div class="ticketholder">
	<div class="table-holder">
		<div class="title-model">
			<h4><i class="fa fa-file"></i> Sales Invoice Details</h4>
		</div>
		<div class="close-btn-holder">
			<button style="display:none" class="btn btn-primary" type="button" name="button"><i class="fa fa-print"></i></button>
			<button class="btn btn-danger" onclick="closeTable()" type="button" name="button"><i class="fa fa-close"></i></button>
		</div>
		<table class="table table-hover mb-none" style="font-size:13px;" id="print_invoice_details">
			<thead>
				<tr>
					<th>#</th>
          <th>Invoice</th>
					<th>Product description</th>
					<th>Quantity</th>
					<th>Currency</th>
					<th>Sold price</th>
					<th>Date</th>
				</tr>
			</thead>
			<tbody id="tbodyforticekt">
			</tbody>
		</table>
		</div>
</div>

<div class="center-panel">
	<section class="panel">
		<header class="panel-heading">
			<div class="panelControl">
				<button id="openModel" class="btn" href="?module=home&action=index" title="Home"> <i class="fa fa-search"></i> Open filter </button>
				<a class="btn" href="?module=home&action=index" title="Home"> <i class="fa fa-home"></i> Home</a>
			</div>
			<h2 class="panel-title">Sales Summery report</h2>
		</header>
		<div class="panel-body">
			<div class="table-responsive">
				<table class="table table-hover mb-none" style="font-size:13px;" id="printing_area">
					<thead>
            			<tr>
                            <th>#</th>
                            <th>Client Name</th>
                            <th>Product Name</th>
                            <th>Product Brand</th>
                            <th>Product Category</th>
                            <th>Product Department</th>
                            <th>Sales Quantity</th>
                            <th>Sales Rate</th>
                            <th>Sales Date</th>
                        </tr>
					</thead>
					<tbody>
           				<?  $count = 1;
                        foreach ($salessummary as $key => $P) {?>

                            <tr>
                                <td><?=$count++?></td>
                                <td><?=$P['clientName']?></td>
                                <td><?=$P['productName']?></td>
                                <td><?=$P['brandName']?></td>
                                <td><?=$P['categoryName']?></td>
                                <td><?=$P['departmentName']?></td>
                                <td><?=$P['quantity']?></td>
                                <td><?=$P['price']?></td>
                                <!-- <td><?=$P['doc']?></td> -->
                                <td><?=$P['docdate']?></td>
                            </tr>  
                        <?}
                    ?>
					</tbody>
				</table>
			</div>
		</div>
	</section>
</div>






<script type="text/javascript">
$(function(){
	$('#departId').select2({width:'100%',minimumInputLength:3,
		ajax:{
			url:"?module=departments&action=getDepartments&format=json",dataType:'json',delay:250,quietMillis:200,
			data: function (term) {return {search:term};},
			results:function (data,page){return{result:data};}
		}
	});

	$("#clientid").select2({ width: '100%', minimumInputLength: 3,
		ajax: {
			url: "?module=clients&action=getClients&format=json", dataType: 'json', delay: 250, quietMillis: 200,
			data: function (term) {	return { search : term }; },
			results: function (data, page) { return { results: data }; }
		}
	 });
})

function closeTable(){
  $('.ticketholder').hide('slow');
}

function getSalesReportDetails(salesid){
  $('.ticketholder').show('slow')
  $.get("?module=reports&action=getSalesReportDetails&format=json&salesid="+salesid, null, function(d){
    var data = eval(d);
    if(data[0].message == "Found"){
      $('#tbodyforticekt').empty();
      var counter = 0
       $.each(data[0].details, function(index, detail){
         counter = index + 1;
         var tableRow = "<tr><td>"+counter+"</td><td>"+detail.invoiceno+"</td><td>"+detail.description+"</td>"+
           "<td>"+detail.qty+"</td><td>"+data[0].currency+"</td><td>"+detail.total+"</td>"+
           "<td>"+detail.issueddate+"</td></tr>";
          $('#tbodyforticekt').append(tableRow);
      })
    }
  });
}

$('#openModel').on('click', function (){
	$('#formHolder').show('slow');
	$('#formModel').show('slow');
	/*$('html, body').css({
    overflow: 'hidden',
    height: '100%'
	});*/
})

$('#closeSearchModel').on('click', function (){
	$('#formHolder').hide('slow');
	$('#formModel').hide('slow');
	/*$('html, body').css({
    overflow: 'auto',
    height: 'auto'
	});*/
})
// $(document).ready(function(){
//  $('#printing_area').DataTable({
// 	 dom: '<"top"fB>t<"bottom"ip>',
// 	 colReorder:true,
// 	 keys:true,
// 	 buttons: ['excelHtml5', 'pdfHtml5','print'],
// 	 <?if($_GET['status']){?>
// 	 title:'<?=$_GET['status']?>',
// 	 <?}?>
//  });
// })

</script>
