<?php

	class Products extends model
	{
		var $table = "products";

		function search($name){
			$sql = "SELECT products.*, products.name AS name, products.id AS productid, departments.name departmentName, units.abbr AS Unit, categories.name AS categoryName, categories.vat_percent AS vatPercent, model.name as brandName FROM `products`
				INNER JOIN departments ON 
				products.departid = departments.id
				LEFT JOIN units ON
				units.id = products.unit
				INNER JOIN categories ON 
				categories.id = products.categoryid
				INNER JOIN model ON
				model.id = products.modelid
				where products.status = 'active' and products.name like '%".$name."%'";
			// $sql = "select name, id, status from products where status = 'active' and name like '%".$name."%'";
			// debug($sql);
			return fetchRows($sql);
		}
		function productDepartment($productId){
			$sql = "select p.id,p.name as productname, d.id as departId,d.name as departname
			from products as p inner join departments as d on d.id = p.departid
			where p.status = 'active' and d.status = 'active' and p.id = $productId";
			return fetchRow($sql);
		}

		function searchResults($name="",$department,$order="",$limit="") {
				$sql = "select * from products where status = 'active'";
				if($name) $sql.=" and name like '%".$name."%'";
				if($department == 0){
					$sql .="";
				}else{
					$sql .=" and departid = ".$department;
				}
				if($order) $sql .=" order by ".$order." desc";
				if($limit) $sql .=" limit ".$limit;
				 //echo $sql;die();
				return fetchRows($sql, $paginate=FALSE);
		}
		function locationproducts($location=""){
			$sql = "SELECT stocks.*, locations.name, products.name, products.status AS status FROM `stocks`

				INNER JOIN locations on
				stocks.locid = locations.id
				
				INNER JOIN products ON
				stocks.productid = products.id
				
				WHERE 1=1";
				if(!empty($location)){
					$sql .=" and stocks.locid = ".$location;
				}
				// debug($sql);
			return fetchRows($sql);
		}
		function getStockProduct_details($stockid,$locationid,$productId){
			$sql = "select s.id,s.productid,s.locid,p.id as proid,p.name as productname,p.trackserialno,
			p.costprice,p.baseprice,p.description,p.forquick_sale,p.quicksale_price,p.point,p.unit,p.barcode_manufacture,
			p.barcode_office,p.flag,c.name as categoryname,c.vat_percent as vat_rate from stocks as s
			inner join products as p on (p.id = s.productid)
			inner join categories as c on (c.id = p.categoryid) where 1=1 ";
			if($stockid) $sql.=" and s.id = $stockid";
			if($productId) $sql.=" and p.id = $productId";
			if($locationid) $sql.=" and s.locid = $locationid";
			// echo $sql;die();
			return fetchRow($sql);
		}
		function getProductDetails($productid=""){
			$sql = "select p.id as proid,p.name as productname,p.trackserialno,
			p.costprice,p.baseprice,p.forquick_sale,p.quicksale_price,p.point,
			p.unit,p.barcode_manufacture,p.barcode_office,p.flag,p.description,
			d.name as departname,m.name as brand,c.name as categoryname,c.vat_percent as vat_rate from products as p
			inner join departments as d on (d.id = p.departid)
			inner join categories as c on (c.id = p.categoryid)
			left join model as m on (m.id = p.modelid) where 1=1 ";
			if($productid) $sql.=" and p.id = $productid";
			//echo $sql;die();
			return fetchRow($sql);
		}
		
		function getProductPriceList($productid=""){
			$sql = "select p.id,p.name as productname from products as p where 1=1";
			if($productid) $sql.=" and p.id = $productid";
			return fetchRows($sql);
		}

		function getProductHistory($locId, $productid, $fromDate, $toDate){
			$output = array();
			//GRN Return
			$sql = "select 'GRN Return' as 'voucher type', g.id as 'voucher no',
			g.doc as date, gd.quantity as quantity,
			l.name as storename, 'out' as 'flow' from grn_returns as g
			inner join grnreturn_details as gd on g.id = gd.returnid
			inner join grn as grn on grn.id = g.grnid
			inner join locations as l on l.id = grn.locid
			inner join stocks as st on st.id = gd.stockid
			inner join products as p on p.id = st.productid
			where 1=1 ";

			if($locId) $sql.=" and grn.locid = $locId ";
			if($productid) $sql.=" and st.productid = $productid ";
			if($fromDate) $sql.=" and g.doc >= '".$fromDate."' ";
			if($toDate) $sql.=" and g.doc <= '".$toDate."' ";

			// echo $sql;die();
			$gr = fetchRows($sql);
			foreach ($gr as $key => $grv) {
				$output[$grv['date']]['grnr'][] = $grv;
			}
			//GRN in (Details)
			$sql = "select 'GRN' as 'voucher type', g.id 'voucher no', g.doc as date, gd.qty as quantity,
			l.name as storename, 'in' as 'flow'from grn as g
			inner join grndetails as gd on g.id = gd.grnid
			inner join locations as l on l.id = g.locid
			inner join stocks as st on st.id = gd.stockid
			inner join products as p on p.id = st.productid
			where 1=1 ";

			if($locId) $sql.=" and g.locid = $locId ";
			if($productid) $sql.=" and st.productid = $productid ";
			if($fromDate) $sql.=" and g.doc >= '".$fromDate."' ";
			if($toDate) $sql.=" and g.doc <= '".$toDate."' ";

			$sql .= " order by g.doc desc";
			// echo $sql;die();
			$gin = fetchRows($sql);

			foreach ($gin as $key => $ginv) {
				$output[$ginv['date']]['grn'][] = $ginv;
			}

			//Transfers of goods (out)
			$sql = "select 'Transfer Out' as 'voucher type', t.id 'voucher no', t.doc as date,
			td.quantity as quantity,
			lf.name as locatinofrom, 'out' as 'flow', lt.name as locationto from stock_transfers as t
			inner join stock_transfer_details as td on t.id = td.transferid
			inner join locations as lf on lf.id = t.location_from
			inner join locations as lt on lt.id = t.location_to
			inner join stocks as st on st.id = td.stock_from
			inner join products as p on p.id = st.productid
			where 1=1 ";

			if($locId) $sql.=" and t.location_from = $locId ";
			if($productid) $sql.=" and st.productid = $productid ";
			if($fromDate) $sql.=" and t.doc >= '".$fromDate."' ";
			if($toDate) $sql.=" and t.doc <= '".$toDate."' ";

			$sql .= " order by t.doc desc";
			//echo $sql;die();
			$tout = fetchRows($sql);
			foreach ( $tout as $v => $toutv ) {
				$output[$toutv['date']]['todOut'][] = $toutv;
			}

			//Transfers of goods (in)
			$sql = "select 'Transfer In' as 'voucher type', t.id as 'voucher no',t.doc as date,
			td.quantity as quantity, lt.name as locationto, 'in' as 'flow',
			lf.name as locationfrom from stock_transfers as t
			inner join stock_transfer_details as td on t.id = td.transferid
			inner join locations as lt on lt.id = t.location_to
			inner join locations as lf on lf.id = t.location_from
			inner join stocks as st on st.id = td.stock_to
			inner join products as p on p.id = st.productid
			where 1=1 ";

			if($locId) $sql.=" and t.location_to = $locId ";
			if($productid) $sql.=" and st.productid = $productid ";
			if($fromDate) $sql.=" and t.doc >= '".$fromDate."' ";
			if($toDate) $sql.=" and t.doc <= '".$toDate."' ";

			$sql .= " order by t.doc desc";
			// echo $sql;die();
			$toin = fetchRows($sql);

			foreach ( $toin as $v => $toinv ) {
				$output[$toinv['date']]['todIn'][] = $toinv;
			}

			//Sales
			$sql = "select 'Invoice' as 'voucher type', s.id as 'voucher no', s.doc as date,
			sd.quantity as quantity, l.name as storename, 'out' as 'flow' from sales as s
			inner join salesdetails as sd on s.id = sd.salesid
			inner join locations as l on l.id = s.locationid
			inner join stocks as st on st.id = sd.stockid
			inner join products as p on p.id = st.productid
			where s.status = 'active' ";

			if($locId) $sql.=" and s.locationid = $locId ";
			if($productid) $sql.=" and st.productid = $productid ";
			if($fromDate) $sql.=" and s.doc >= '".$fromDate."' ";
			if($toDate) $sql.=" and s.doc <= '".$toDate."' ";

			$sql .= " order by s.doc desc";
			$sal = fetchRows($sql);
			// echo $sql;die();
			foreach ($sal as $v => $salv ) {
				$output[$salv['date']]['sales'][] = $salv;
			}

			return $output;
		}

		function maxID(){
			$sql = "SELECT MAX(id) AS maxID FROM products";
			return fetchRow($sql);
		}
}

?>
