<?php
/**
 *  sales
 */
class Sales extends model{
  var $table = "sales";

  function sales($saleid="", $Unfiscalised=""){
    $sql = "SELECT sales.*, clients.name AS clinetName, clients.id AS clientID, clients.address AS clientaddress, clients.tinno AS clientTIn, clients.vatno AS clientVATno, clients.mobile
         AS clientMobile, locations.name AS locationName, locations.id AS locationID, users.name AS salespersonName, date_format(sales.doc,'%D-%M-%Y') as doc FROM `sales`

            INNER JOIN clients ON
            clients.id = sales.clientid

            INNER JOIN locations ON
            locations.id = sales.locationid

            INNER JOIN users ON
            users.id = sales.salespersonid

            WHERE 1 = 1";

            if($saleid) $sql.=" and sales.id = $saleid";

            if (!empty($Unfiscalised) && $Unfiscalised ==1) {
                $sql .= " and sales.rctvcode is NULL";
            }
            $sql .= " ORDER BY `sales`.`id`  DESC";
            // debug($sql);
        return fetchRows($sql);
  }

  function getUnfiscalised($value=''){
      $sql = "SELECT sales.*, clients.name AS clinetName, clients.id AS clientID, clients.address AS clientaddress, clients.tinno AS clientTIn, clients.vatno AS clientVATno, clients.mobile
         AS clientMobile, locations.name AS locationName, locations.id AS locationID, users.name AS salespersonName FROM `sales`

            INNER JOIN clients ON
            clients.id = sales.clientid

            INNER JOIN locations ON
            locations.id = sales.locationid

            INNER JOIN users ON
            users.id = sales.salespersonid

            WHERE sales.id = $saleid";
            debug($sql);
        return fetchRows($sql);
  }

  function salesList($createdby="",$salesid="",$group=true){
    $sql = "select s.id as salesid, s.receipt_numreceipt_num, s.rctvcode,s.znumber,s.vfd_status_message,s.vfd_qrcode, s.paymenttype as paymenttype,s.clientid,s.orderid,s.proformaid,s.ticketid,s.vat_status,s.payment_status,
    s.grand_amount,s.grand_base_amount,s.grand_vatamount,s.grand_base_vatamount,
    s.description,s.full_amount,s.lastpaid_totalamount,
    s.receipt_method,s.receipt_date,date_format(s.doc,'%D-%M-%Y') as issue_date,s.vfdc,s.receipt_num,sd.exchange_rate,sd.price,
    sd.base_price,sd.amount,sd.base_amount,sd.quantity,sd.vat_rate,sd.actual_vat,sd.vat_amount,sd.base_vat_amount,
    sd.serialid,sd.serialno,c.name as clientname,c.tinno as clientino,c.mobile,cu.name as currencyname,p.name as productname,p.id as productid, stl.name as stocklocation,
    s.iscreditapproved,s.iscost_added,u.name as acc_manager,us.name as sales_person,taxcode.vfdipa_code as taxcode, units.abbr as units from sales as s
    inner join clients as c on c.id = s.clientid
    inner join locations as stl on stl.id = s.locationid
    inner join salesdetails as sd on sd.salesid = s.id
    inner join stocks as st on st.id = sd.stockid
    inner join products as p on p.id = st.productid
    inner join categories on categories.id = p.categoryid
    inner join taxcode on categories.taxcode = taxcode.id
    inner join currencies as cu on cu.id = sd.currencyid
    inner join users as u on u.id = s.createdby
    inner join units as units on units.id = p.unit
    left join users as us on us.id = s.salespersonid where 1=1";

    if($salesid) $sql.=" and sd.salesid = $salesid";
    if($createdby) $sql.=" and s.createdby = $createdby";
    if($group) $sql .=" group by s.id";
    $sql .=" order by s.doc desc";
    // echo $sql;die();
    return fetchRows($sql);
  }
  function getSalesOustanding($salesid="",$clientid="",$createdby=""){
    $sql = "select s.id as salesid, s.doc as invoice_date, s.credit_days as credit_days, s.payment_status, s.grand_amount,
    s.grand_vatamount, s.full_amount,s.lastpaid_totalamount,
    (s.full_amount - s.lastpaid_totalamount) as pending_amount,
    date_format(s.doc,'%d-%M-%Y') as issue_date, date_format(s.duedate,'%d-%M-%Y') as due_date, c.name as clientname,
    s.iscreditapproved,u.name as acc_manager, datediff(CURDATE(),s.doc) as day,
    case when  datediff(CURDATE(),s.duedate) < 30 then (s.full_amount - s.lastpaid_totalamount) end as '(<30 days)',
    case when  datediff(CURDATE(),s.duedate) >= 30 and datediff(CURDATE(),s.duedate)< 45 then (s.full_amount - s.lastpaid_totalamount) end as '(30 to 45 days)',
    case when  datediff(CURDATE(),s.duedate) >= 45 and datediff(CURDATE(),s.duedate)< 90 then (s.full_amount - s.lastpaid_totalamount) end as '(45 to 90 days)',
    case when  datediff(CURDATE(),s.duedate) >= 90 then (s.full_amount - s.lastpaid_totalamount) end as '(>90 days)'
    from sales as s
    inner join clients as c on c.id = s.clientid
    inner join users as u on u.id = s.createdby where s.payment_status = 'pending' ";

    if($clientid) $sql.=" and s.clientid = $clientid";
    if($salesid) $sql.=" and sd.salesid = $salesid";
    if($createdby) $sql.=" and s.createdby = $createdby";
    $sql .=" order by s.doc desc";
    //echo $sql;die();
    return fetchRows($sql);
  }

  function invoice_payment_term($salesid){
    $sql = "select s.id,s.payment_status,sp.remark,pm.name from sales as s
    inner join salespayment_details as spd on spd.salesid = s.id
    inner join salespayments as sp on sp.id = spd.salespaymentId
    inner join paymentmethods as pm on pm.id = sp.pmethod_id where 1=1 ";
    if($salesid) $sql.=" and s.id = $salesid ";
    //echo $sql;die();
    return fetchRows($sql);
  }

  function dailyCashSales($userid="",$clientid="",$fromdate="",$todate="", $credit=""){
    $sql = "select s.id as invoiceno,date_format(s.doc,'%d/%m/%y') as issudate,
    spd.amount as paid_amount,
    c.name as clientname,pm.name as invoive_type,
    cu.name as currency_name from sales as s
    inner join clients as c on c.id = s.clientid
    inner join salespayment_details as spd on spd.salesid = s.id
    inner join salespayments as sp on sp.id = spd.salespaymentId
    inner join paymentmethods as pm on pm.id = sp.pmethod_id
    inner join salesdetails as sd on sd.salesid = s.id
    inner join currencies as cu on cu.id = sd.currencyid where 1=1 ";

    if($userid) $sql .=" and s.createdby = $userid ";
    if($credit == 1) $sql .=" and s.paymenttype = 'credit' ";
    if($clientid) $sql .=" and c.id = $clientid ";
    if ($fromdate)$sql .=" and s.doc >= '".$fromdate."'";
    if ($todate) $sql .=" and s.doc < '".$todate."'";

    // $sql.=" group by s.id,c.id,pm.id,cu.id,spd.id";
    // debug($sql);
    // echo $sql;die();
    return fetchRows($sql);
  }

  function dailyCreditSales($userid="",$clientid="",$fromdate="",$todate="", $credit=""){
    $sql = "select s.*, s.id as invoiceno,
    date_format(s.doc,'%D,%M %Y') as issudate,
    c.name as clientname,
    s.paymenttype as invoive_type,
    cu.name as currency_name ,
    users.name as salesPerson
    from sales as s
    inner join clients as c on c.id = s.clientid
    inner join users on s.createdby = users.id
    inner join salesdetails as sd on sd.salesid = s.id
    inner join currencies as cu on cu.id = sd.currencyid where 1=1 ";

    if($userid) $sql .=" and s.createdby = $userid ";
    if($credit == 1) $sql .=" and s.paymenttype = 'credit' ";
    if($clientid) $sql .=" and c.id = $clientid ";
    if ($fromdate)$sql .=" and s.doc >= '".$fromdate."'";
    if ($todate) $sql .=" and s.doc < '".$todate."'";
    $sql.=" ORDER BY `sd`.`id`  DESC";
    $sql.=" LIMIT 10";

    // $sql.=" group by s.id,c.id,pm.id,cu.id,spd.id";
    // debug($sql);
    // echo $sql;die();
    return fetchRows($sql);
  }

  function mostSalesProduct($fromdate="", $todate=""){
    $sql = "SELECT salesdetails.quantity AS quantity, products.name AS productName
            , model.name as brandname
            , categories.name as catName
            , departments.name as departName
            , sales.doc AS doc
            , COUNT(salesdetails.stockid) AS Count 
            FROM `salesdetails` 
            INNER JOIN stocks ON
            salesdetails.stockid = stocks.id

            INNER JOIN products ON
            products.id = stocks.productid
            
            INNER JOIN model ON
            products.modelid = model.id
            
            INNER JOIN categories ON
            products.categoryid = categories.id
            
            INNER JOIN departments ON
            products.departid = departments.id

            INNER JOIN sales ON 
            salesdetails.salesid = sales.id

            WHERE 1=1";

            if ($fromdate) $sql .=" and sales.doc >= '".$fromdate."'";
            if ($todate) $sql .=" and sales.doc <= '".$todate."'";
            
            $sql .= " GROUP BY products.id ";
            $sql .= " ORDER BY `Count`  DESC";
            $sql .= " limit 10";

    // debug($sql);
    return fetchRows($sql);
  }



  function dashboardcashsales($userid="",$clientid="",$fromdate="",$todate="", $credit=""){
    $sql = "select s.*, s.id as invoiceno,
    date_format(s.doc,'%D,%M %Y') as issudate,
    c.name as clientname,
    s.paymenttype as invoive_type,
    cu.name as currency_name ,
    users.name as salesPerson
    from sales as s
    inner join clients as c on c.id = s.clientid
    inner join users on s.createdby = users.id
    inner join salesdetails as sd on sd.salesid = s.id
    inner join currencies as cu on cu.id = sd.currencyid where 1=1 ";

    if($userid) $sql .=" and s.createdby = $userid ";
    if($credit == 1) $sql .=" and s.paymenttype = 'credit' ";
    if($credit == 0) $sql .=" and s.paymenttype = 'cash' ";
    if($clientid) $sql .=" and c.id = $clientid ";
    if ($fromdate)$sql .=" and s.doc >= '".$fromdate."'";
    if ($todate) $sql .=" and s.doc < '".$todate."'";

    $sql.=" ORDER BY `sd`.`id`  DESC";
    $sql.=" LIMIT 10";
    // debug($sql);
    // echo $sql;die();
    return fetchRows($sql);
  }

  function ledgerAccount($clientid="",$currency="",$fromdate="",$todate=""){
    $sql="select concat(s.id,'inv')  as concat_invoiceno,s.id as invoiceno,date_format(s.doc,'%d-%M-%Y') as invoice_date,
    s.full_amount as invoice_amount,sum(s.full_amount) as invoice_grand
    ,concat(sp.id,'rct') as concat_receiptno,sp.id as receiptno,date_format(sp.doc,'%d-%M-%Y') as payment_date,
    sp.paid_totalmount,sum(sp.paid_totalmount) as receipt_grand,c.id as clientid,cu.name as current_name
    from clients as c
    inner join sales as s on s.clientid = c.id
    inner join salesdetails as sd on sd.salesid = s.id
    inner join currencies as cu on cu.id = sd.currencyid
    inner join salespayments as sp on sp.clientid = c.id
    where 1=1 ";
    if($clientid) $sql.=" and c.id = $clientid";
    if($currency) $sql.=" and sd.currencyid = $currency";
    if($fromdate)$sql .=" and s.doc >= '".$fromdate."' and sp.doc >= '".$fromdate."' ";
    if($todate) $sql .=" and s.doc <= '".$todate."' and sp.doc <= '".$todate."' ";
    $sql.=" group by c.id,s.id,sp.id,s.full_amount,sp.paid_totalmount";
    // echo $sql;die();
    return fetchRows($sql);
  }

  function salesInvoiceList($salesid="",$clientid=""){
    $sql = "select s.id as salesid,s.clientid,s.orderid,s.proformaid,s.vat_status,s.payment_status,
    s.grand_amount,s.grand_base_amount,s.grand_vatamount,s.grand_base_vatamount,s.isreceipt_printed,
    s.receipt_num,s.receipt_method,
    c.name as clientname,stl.name as stocklocation,s.iscreditapproved from sales as s
    inner join clients as c on c.id = s.clientid
    inner join locations as stl on stl.id = s.locationid where 1=1";

    if($salesid) $sql.=" and sd.salesid = $salesid";
    if($clientid) $sql.=" and c.id = $clientid";
    $sql .=" order by s.doc desc";
    //echo $sql;die();
    return fetchRows($sql);
  }
  function clientInvoiceList($clientid){
    $sql = "select c.id,c.name as clientname,c.mobile,c.email,
    count(s.id) as total_invoice from clients as c
    left join sales as s on s.clientid = c.id
    where  c.status = 'active' and s.status = 'active' ";
    if($clientid) $sql.=" and c.id = $clientid ";
    $sql.= " group by c.id order by total_invoice desc";
    return fetchRows($sql);
  }

  function getInvoiceAmounts($invoice_list = 0){
    $sql = "select id as invoiceno,grand_amount,full_amount,lastpaid_totalamount from sales where id in ($invoice_list)";
    //echo $sql;die();
    return fetchRows($sql);
  }
  //VFD numbers
  // 1. VFD GC
  // 2. VFD DC
  function get_vfd_numbers($forVfgc=false){
    $sql = "select ";
    if($forVfgc){
      $sql .=" max(vfgc)+1 as gc from sales";
      $number = fetchRow($sql);
    }else{
      $sql .=" max(vfdc)+1 as dc from sales where DATE_FORMAT(doc, '%Y-%m-%d') = curdate()";
      $number = fetchRow($sql);
      if($number['dc'] == '' || $number['dc'] == null) $number['dc'] = 1;
    }
    //echo $sql;die();
    return $number[($forVfgc)?'gc':'dc'];
  }
  //invoice cretion date
  function get_invoice_cd($salesid){
    $sql = "select date_format(doc, '%Y%m%d') as znum from sales where id = $salesid";
    $znum = fetchRow($sql);
    return $znum['znum'];
  }
  function getPurchasedProductClient($productid="",$salespersonid=""){
    $sql = "select s.id as invoiceno,date_format(s.doc,'%d %M %Y') as purchase_date,c.name as clientname from sales as s
    inner join salesdetails as sd on (sd.salesid = s.id)
    inner join stocks as st on (st.id = sd.stockid)
    inner join products as p on (p.id = st.productid)
    inner join clients as c on (c.id = s.clientid)
    inner join users as u on (u.id = s.salespersonid)
    where 1=1 ";
    if($productid) $sql.=" and st.productid = $productid ";
    if($salespersonid) $sql.=" and s.salespersonid = $salespersonid";
    $sql .=" order by s.doc desc";
    //echo $sql;die();
    return fetchRows($sql);
  }
  function salesAuditReport($fromdate="",$todate=""){
    $sql = "select sd.id,date_format(s.doc,'%d/%m/%Y') as createdate,sd.salesid,sd.stockid,sd.exchange_rate,
    sd.price,sd.quantity,sd.amount,sd.hidden_cost,
    (((sd.price - sd.hidden_cost)/ sd.hidden_cost) * 100) as margin_percent,
    sd.vat_rate,sd.vat_amount,p.id as productid,
    p.name as productname,p.description,categories.name as catName,cu.name as currencyname, taxcode.name as taxcose, model.name as brandname, c.name as clientname,
    u.name as salesperson from sales as s
    inner join salesdetails as sd on sd.salesid = s.id
    inner join stocks as st on st.id = sd.stockid
    inner join products as p on p.id = st.productid
    inner join categories on categories.id = p.categoryid
    inner join taxcode on categories.taxcode = taxcode.id
    inner join clients as c on c.id = s.clientid
    inner join model on p.modelid = model.id
    inner join currencies as cu on cu.id = sd.currencyid
    inner join users as u on u.id = s.createdby where 1=1 
    and s.iscreditapproved=1";

    //if ($fromdate)	$sql.=" and s.doc >= '".$fromdate."'";
		//if ($todate)    $sql.=" and s.doc <= '".$todate."'";
    $sql .=" order by s.doc desc";
    //echo $sql;die();
    // debug($sql);
    return fetchRows($sql);
  }





  function productSales($clientid='',$user='',$productid='',$modelid='',$catid='',$deptid='',$fromdate='',$todate=''){
      $sql = "SELECT sales.*, clients.name AS clientName, sales.doc AS saleDate, salesdetails.quantity AS quantity, salesdetails.price AS price, products.name AS productName, date_format(sales.doc,'%d %M %Y') as docdate, model.name as brandName, categories.name AS categoryName, departments.name as departmentName FROM `sales`  

        INNER JOIN clients ON
        sales.clientid = clients.id

        INNER JOIN users ON
        sales.createdby = users.id

        INNER JOIN salesdetails on 
        sales.id = salesdetails.salesid

        INNER JOIN stocks ON
        stocks.id = salesdetails.stockid

        INNER JOIN products ON
        products.id = stocks.productid

        INNER JOIN categories ON 
        products.categoryid = categories.id

        INNER JOIN model ON
        products.modelid = model.id

        INNER JOIN departments ON
        products.departid = departments.id

        WHERE 1=1";
        if($productid) $sql.=" and products.id = $productid ";
        if($clientid) $sql.=" and clients.id = $clientid ";
        if($user) $sql.=" and users.id = $user ";
        if($modelid) $sql.=" and model.id = $modelid ";
        if($catid) $sql.=" and categories.id = $catid ";
        if($deptid) $sql.=" and departments.id = $deptid ";
        if($fromdate) $sql.=" and sales.doc >= $fromdate ";
        // if($todate) $sql.=" -- and sales.doc <= $todate ";

        $sql.=" ORDER BY `sales`.`id`  DESC";
        // debug($sql);
        return fetchRows($sql);
  }
}
 ?>
