<?

class Stocks extends model{
	var $table = "stocks";
	function getDefaultStockLocation($locid="",$default=true){
		$sql = "select l.id,l.name as location_name,l.address,l.type,
		b.name as branch_name from locations as l
		inner join branches as b on b.id = l.branchid
		where 1=1 ";
		if($default) $sql.=" and l.default_load = 1";
		if($locid) $sql.=" and l.id = $locid";
		//echo $sql;die();
		return fetchRow($sql);
	}

	function getLPOs($lpoid="", $fromdate="", $todate="", $supplierid=""){
		$sql = "select l.id as lponumber,g.id as grnnumber, l.doc as issuedate,
		s.name as suppliername,l.total_amount,l.base_totalAmount,l.full_amount,l.base_full_amount,
		l.grand_vatamount,l.grand_base_vatamount,l.currency_amount,l.currency_rateid,lpd.prodid,
		cu.name as currency_name,u.name as issuedby from lpo as l
		inner join lpodetails as lpd on lpd.lpoid = l.id
		inner join suppliers as s on s.id = l.supplierid
		left join currencies_rates as cur on cur.id = l.currency_rateid
		left join currencies as cu on cu.id = cur.currencyid
		left join grn as g on g.lpoid = l.id
		inner join users as u on u.id = l.createdby where l.status='active' ";
		
		if($lpoid !="") $sql.=" and l.id = $lpoid";
		if($supplierid !="") $sql.=" and l.supplierid = $supplierid";
		if($fromdate !="") $sql.=" and l.doc >= $fromdate";
		if($todate !="") $sql.=" and l.doc <= $todate";

		$sql.=" group by l.id order by l.doc desc";
		// echo $sql; die();
		return fetchRows($sql);
	}

	function getLPO($lponumber=""){
		$sql = "select l.id as lponumber,l.total_amount,l.base_totalAmount,l.full_amount,l.base_full_amount,
		l.grand_vatamount,l.grand_base_vatamount,l.currency_amount,cu.description as currency_description
		,cu.name as currency_name,l.currency_rateid,
		l.doc as issuedate,p.name as productname,lpd.prodid,lpd.barcode,lpd.qty, lpd.model,
		lpd.prod_cost,lpd.base_amount,
		lpd.rate,lpd.base_rate,lpd.vat_amount,lpd.vat_rate,lpd.base_vat_amount,s.name as suppliername,
		u.name as issuedby, s.id as supplierid from lpo as l
		inner join lpodetails as lpd on lpd.lpoid = l.id
		inner join products as p on p.id = lpd.prodid
		inner join suppliers as s on s.id = l.supplierid
		left join currencies_rates as cur on cur.id = l.currency_rateid
		left join currencies as cu on cu.id = cur.currencyid
		inner join users as u on u.id = l.createdby where 1=1 and l.status = 'active' ";

		if($lponumber) $sql .=" and l.id=$lponumber";
		//echo $sql; die();
		return fetchRows($sql);
	}

	function getGRNs($lpoid="", $grnid="", $fromdate="", $todate="", $supplierid=""){
		$sql = "select g.id as grnnumber,g.lpoid as lponumber, g.doc as issuedate,
		s.name as suppliername,g.total_amount,gd.stockid,
		g.total_amount,g.base_totalAmount,g.full_amount,g.base_full_amount,
		g.grand_vatamount,g.grand_base_vatamount,g.currency_amount,g.currency_rateid,
		cu.name as currency_name,u.name as issuedby from grn as g
		inner join grndetails as gd on gd.grnid = g.id
		inner join suppliers as s on s.id = g.supplierid
		left join currencies_rates as cur on cur.id = g.currency_rateid
		left join currencies as cu on cu.id = cur.currencyid
		inner join users as u on u.id = g.createdby where 1=1";
		
		if($grnid !="") $sql.=" and g.id = $grnid";
		if($lpoid !="") $sql.=" and g.lpoid = $lpoid";
		if($supplierid !="") $sql.=" and g.supplierid = $supplierid";
		if($fromdate !="") $sql.=" and g.doc >= $fromdate";
		if($todate !="") $sql.=" and g.doc <= $todate";

        $sql .=" group by g.id ORDER BY g.id DESC ";

		// debug($sql);
		return fetchRows($sql);
	}

	function getGRN($grnnumber=""){
		$sql = "select g.id as grnnumber,g.lpoid, g.verificationcode as verificationcode, g.total_amount,g.grand_vatamount,g.full_amount,
		g.base_full_amount,g.grand_base_vatamount,g.base_totalAmount,g.invoiceno,g.doc as issuedate,
		g.currency_amount,gd.stockid,gd.barcode, gd.model,gd.qty,sum(gd.qty) as sum_qty,gd.rate, gd.pro_cost,
		p.trackserialno,p.id as prodid,p.name as productname,lo.id as st_locid,lo.name as stock_location,
		cu.name as currency_name,cu.description as currency_description,
		s.id as supplierid,s.name as suppliername, u.name as issuedby from grn as g
		inner join grndetails as gd on gd.grnid = g.id
		inner join stocks as st on st.id = gd.stockid
		inner join locations as lo on lo.id = st.locid
		inner join products as p on p.id = st.productid
		inner join suppliers as s on s.id = g.supplierid
		inner join currencies_rates as cr on cr.id = g.currency_rateid
		inner join currencies as cu on cu.id = cr.currencyid
		inner join users as u on u.id = g.createdby where 1=1 ";

		if($grnnumber) $sql .=" and g.id=$grnnumber";
		 $sql.=" group by p.id,gd.qty ";
		// debug($sql);
		return fetchRows($sql);
	}

	function getCurrentStock($locationid,$proname="",$search_barcode="",$purpose=""){
		$sql = "select product_name,
		pro_stockid,
    product_id,
    product_price,
		productbarcode,
    coalesce(((quantity + tin) - (tout + sales_out)), 0) as quantity
		from (select product_name,
		pro_stockid,
    product_id,
    product_price,
		productbarcode,
    coalesce(sales_out, 0) as sales_out,
    coalesce(quantity, 0)  as quantity,
    coalesce(transfer_in, 0)  as tin,
    coalesce(transfer_out, 0) as tout
    from (select prod.name as product_name,
									stock.id as pro_stockid,
                   stock.productid   as product_id,
                   prod.costprice as product_price,
									 prod.barcode_office as productbarcode,
                   (SELECT SUM(grndetails.qty)
                    FROM grndetails
                    LEFT JOIN grn on (grndetails.grnid = grn.id)
										LEFT JOIN stocks as stockgrn on (stockgrn.id = grndetails.stockid)
                    WHERE (grn.locid = stock.locid and stockgrn.productid = prod.id)
                    GROUP BY stockgrn.productid) as quantity,
                   (SELECT SUM(det.quantity)
                    FROM stock_transfer_details as det
                             left join stocks as st on (det.stock_to = st.id)
                             left join products as p on (st.productid = p.id)
                    WHERE (st.locid = stock.locid and st.productid = stock.productid)
                    GROUP BY st.productid) as transfer_in,
                   (SELECT SUM(det.quantity)
                    FROM stock_transfer_details as det
                             left join stocks as st on (det.stock_from = st.id)
                             left join products as p on (st.productid = p.id)
                    WHERE (st.locid = stock.locid and st.productid = stock.productid)
                    GROUP BY st.productid) as transfer_out,
                   (SELECT SUM(det.quantity)
                    FROM salesdetails as det
                             left join stocks as st on (det.stockid = st.id)
                             left join products as p on (st.productid = p.id)
                    WHERE (st.locid = stock.locid and st.productid = stock.productid)
                    GROUP BY st.productid) as sales_out
            from stocks as stock
            left join grn as grn on (stock.locid = grn.locid)
            left join grndetails as grn_p on (grn.id = grn_p.grnid)
            left join stock_transfers as tra_in on (stock.locid = tra_in.location_from)
            left join stock_transfers as tra_out on (stock.locid = tra_out.location_to)
            left join products as prod on (stock.productid = prod.id)
            where
						stock.locid = $locationid";

						if($proname) $sql.=" and prod.name like '%$proname%'";
						if($search_barcode) $sql.=" and prod.barcode_office = $search_barcode";
						if($purpose) $sql.=" and prod.forquick_sale = $purpose";
						$sql.=" group by stock.productid) StockTable) FinalTable";
		//echo $sql;die();
		return fetchRows($sql);
}

function calcStock($locid="",$stockid="",$stkdate="",$productname="",$prodid="",$office_barcode="",$manufacture_barcode="",$purpose="") {
  	if (!$stkdate) $stkdate = date('Y-m-d',strtotime('+1 day'));
  	$sql = "select id, productid, name,costprice,barcode_office,barcode_manufacture,forquick_sale,description, sum(total) as total from (
			(select s.id, s.productid, p.name,p.costprice,p.barcode_office,p.barcode_manufacture,p.forquick_sale,p.description, sum(gd.qty) as total
    from grn as g
    inner join grndetails as gd on g.id = gd.grnid
    inner join stocks as s on s.id = gd.stockid
    inner join products as p on p.id = s.productid
    where g.doc <= '".$stkdate."' and g.locid = $locid
    group by s.id,s.productid,p.name,p.costprice,p.barcode_office,p.barcode_manufacture,p.forquick_sale,p.description)

    union all

    (select s.id, s.productid, p.name,p.costprice,p.barcode_office,p.barcode_manufacture,p.forquick_sale,p.description, -sum(grd.quantity) as total
    from grn_returns as gr
    inner join grnreturn_details as grd ON grd.returnid = gr.id
    inner join stocks as s on s.id = grd.stockid
    inner join products as p on p.id = s.productid
  	where gr.doc <= '".$stkdate."' and gr.locid = $locid
    group by s.id,s.productid,p.name,p.costprice,p.barcode_office,p.barcode_manufacture,p.forquick_sale,p.description)

    union all

    (select s.id, s.productid, p.name,p.costprice,p.barcode_office,p.barcode_manufacture,p.forquick_sale,p.description, -sum(sd.quantity) as total from sales sa
    inner join salesdetails as sd on sd.salesid = sa.id
    inner join stocks as s on s.id = sd.stockid
    inner join products as p on p.id = s.productid
    where sa.iscreditapproved=1 and sa.doc <= '".$stkdate."' and sa.locationid = $locid
    group by s.id,s.productid,p.name,p.costprice,p.barcode_office,p.barcode_manufacture,p.forquick_sale,p.description )

    union all

		(select s.id, s.productid, p.name,p.costprice,p.barcode_office,p.barcode_manufacture,p.forquick_sale,p.description, -sum(std.quantity) as total from stock_transfers st
    inner join stock_transfer_details as std on std.transferid = st.id
    inner join stocks as s on s.id = std.stock_from
    inner join products as p on p.id = s.productid
    where st.doc <= '".$stkdate."'";

    if($locid) $sql.=" and st.location_from = $locid ";

    $sql.=" group by s.id,s.productid,p.name,p.costprice,p.barcode_office,p.barcode_manufacture,p.forquick_sale,p.description) union all

		(select s.id, s.productid, p.name,p.costprice,p.barcode_office,p.barcode_manufacture,p.forquick_sale,p.description, sum(stdin.quantity) as total from stock_transfers stin
    inner join stock_transfer_details as stdin on stdin.transferid = stin.id
    inner join stocks as s on s.id = stdin.stock_to
    inner join products as p on p.id = s.productid
    where stin.doc <= '".$stkdate."'";

    if($locid) $sql.=" and stin.location_to = $locid ";

    $sql.=" group by s.id,s.productid,p.name,p.costprice,p.barcode_office,p.barcode_manufacture,p.forquick_sale,p.description) )as x where 1 = 1";

  	if (!empty($productname)) $sql .= " and name like '%".$productname."%'";
  	if (!empty($prodid)) $sql .= " and productid = " . $prodid;
	if (!empty($office_barcode)) $sql.=" and barcode_office = $office_barcode";
	if (!empty($manufacture_barcode)) $sql.=" and barcode_manufacture = $manufacture_barcode";
	if(!empty($purpose)) $sql.=" and forquick_sale = $purpose";
  	if (!empty($stockid)) $sql .= " and id = " . $stockid;
  	$sql .= " group by id, productid, name,costprice,barcode_office,barcode_manufacture,forquick_sale,description";
  	$sql .= " order by total DESC";
	// echo "<pre>";echo $sql;die(); 
		return fetchRows($sql);
  }

function getStockAvailableSerials($productid="",$serialno="",$locid=""){
	if (!$stkdate) $stkdate = date('Y-m-d',strtotime('+1 day'));
	$sql = "select id,serialno, sum(total) as total from (
		(select se.id,se.name as serialno, 1 as total from grn as g
		inner join grndetails as gd ON g.id = gd.grnid
	  inner join stocks as s ON s.id = gd.stockid
	  inner join products as p on p.id = s.productid
		inner join serials as se on se.id = gd.serialid
		where g.doc <= '".$stkdate."' and s.productid = ".$productid." and g.locid = ".$locid."
		group by se.id,gd.serialid)

		union all

		(select se.id,se.name as serialno,-1 as total from grn_returns as gr
	  inner join grnreturn_details as grd ON grd.returnid = gr.id
	  inner join stocks as s ON s.id = grd.stockid
	  inner join products as p on p.id = s.productid
		inner join serials as se on se.id = grd.serialid
		where gr.doc <= '".$stkdate."' and s.productid = ".$productid." and gr.locid = ".$locid."
		group by se.id,grd.serialid)

		union all

		(select se.id,se.name as serialno,-1 as total from sales sa
    inner join salesdetails as sd on sd.salesid = sa.id
    inner join stocks as s on s.id = sd.stockid
    inner join products as p on p.id = s.productid
		inner join serials as se on se.id = sd.serialid
    where sa.iscreditapproved=1 and sa.doc <= '".$stkdate."' and s.productid = ".$productid."
		and sa.locationid = $locid
    group by se.id,sd.serialid)

		union all

		(select se.id,se.name as serialno,-1 as total from stock_transfers st
    inner join stock_transfer_details as std on std.transferid = st.id
    inner join stocks as s on s.id = std.stock_from
    inner join products as p on p.id = s.productid
		inner join serials as se on se.id = std.serialid
    where st.doc <= '".$stkdate."' and s.productid = ".$productid." and st.location_from = $locid
    group by se.id,std.serialid)

		union all

		(select se.id,se.name as serialno,1 as total  from stock_transfers stin
    inner join stock_transfer_details as stdin on stdin.transferid = stin.id
    inner join stocks as s on s.id = stdin.stock_to
    inner join products as p on p.id = s.productid
		inner join serials as se on se.id = stdin.serialid
    where stin.doc <= '".$stkdate."' and s.productid = ".$productid." and stin.location_to = $locid
    group by se.id,stdin.serialid)) as x where serialno <> '' ";
		if($serialno) $sql.=" and serialno like '%$serialno%'";
		$sql.=" group by id,serialno";
		//echo "<pre>"; echo $sql;die();
		return fetchRows($sql);
}

function getStockId($productid,$locationid){
	$sql = "select s.id,s.productid,p.id as prodid,p.name as productname,
	 l.id as locationid,l.name as locname from stocks as s
	 inner join products as p on p.id = s.productid
	 inner join locations as l on l.id = s.locid where p.id = $productid and s.locid = $locationid";
	 //echo $sql;die();
	 return fetchRow($sql);
}



}
